/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.util.Assert;
import reactor.core.Exceptions;

final class SubscriberInputStream
extends InputStream
implements Subscriber<DataBuffer> {
    private static final Object READY = new Object();
    private static final DataBuffer DONE = DefaultDataBufferFactory.sharedInstance.allocateBuffer(0);
    private static final DataBuffer CLOSED = DefaultDataBufferFactory.sharedInstance.allocateBuffer(0);
    private final int prefetch;
    private final int limit;
    private final ReentrantLock lock;
    private final Queue<DataBuffer> queue;
    private final AtomicReference<@Nullable Object> parkedThread = new AtomicReference();
    private final AtomicInteger workAmount = new AtomicInteger();
    private volatile boolean closed;
    private int consumed;
    private @Nullable DataBuffer available;
    private @Nullable Subscription subscription;
    private boolean done;
    private @Nullable Throwable error;

    SubscriberInputStream(int demand) {
        this.prefetch = demand;
        this.limit = demand == Integer.MAX_VALUE ? Integer.MAX_VALUE : demand - (demand >> 2);
        this.queue = new ArrayBlockingQueue<DataBuffer>(demand);
        this.lock = new ReentrantLock(false);
    }

    public void onSubscribe(Subscription subscription) {
        if (this.subscription != null) {
            subscription.cancel();
            return;
        }
        this.subscription = subscription;
        subscription.request(this.prefetch == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.prefetch);
    }

    public void onNext(DataBuffer buffer) {
        int previousWorkState;
        Assert.notNull((Object)buffer, "DataBuffer must not be null");
        if (this.done) {
            this.discard(buffer);
            return;
        }
        if (!this.queue.offer(buffer)) {
            this.discard(buffer);
            this.error = new RuntimeException("Buffer overflow");
            this.done = true;
        }
        if ((previousWorkState = this.addWork()) == Integer.MIN_VALUE) {
            DataBuffer value = this.queue.poll();
            if (value != null) {
                this.discard(value);
            }
            return;
        }
        if (previousWorkState == 0) {
            this.resume();
        }
    }

    public void onError(Throwable throwable) {
        if (this.done) {
            return;
        }
        this.error = throwable;
        this.done = true;
        if (this.addWork() == 0) {
            this.resume();
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.addWork() == 0) {
            this.resume();
        }
    }

    int addWork() {
        int nextProduced;
        int produced;
        do {
            if ((produced = this.workAmount.getPlain()) != Integer.MIN_VALUE) continue;
            return Integer.MIN_VALUE;
        } while (!this.workAmount.weakCompareAndSetRelease(produced, nextProduced = produced == Integer.MAX_VALUE ? 1 : produced + 1));
        return produced;
    }

    private void resume() {
        Object old;
        if (this.parkedThread.get() != READY && (old = this.parkedThread.getAndSet(READY)) != READY) {
            LockSupport.unpark((Thread)old);
        }
    }

    @Override
    public int read() throws IOException {
        if (!this.lock.tryLock()) {
            if (this.closed) {
                return -1;
            }
            throw new ConcurrentModificationException("Concurrent access is not allowed");
        }
        try {
            DataBuffer next = this.getNextOrAwait();
            if (next == DONE) {
                this.closed = true;
                this.cleanAndFinalize();
                if (this.error == null) {
                    int n = -1;
                    return n;
                }
                throw Exceptions.propagate((Throwable)this.error);
            }
            if (next == CLOSED) {
                this.cleanAndFinalize();
                int n = -1;
                return n;
            }
            int n = next.read() & 0xFF;
            return n;
        }
        catch (Throwable ex) {
            this.closed = true;
            this.requiredSubscriber().cancel();
            this.cleanAndFinalize();
            throw Exceptions.propagate((Throwable)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        if (!this.lock.tryLock()) {
            if (this.closed) {
                return -1;
            }
            throw new ConcurrentModificationException("concurrent access is disallowed");
        }
        try {
            int j;
            int initialReadPosition;
            DataBuffer next;
            for (j = 0; j < len; j += next.readPosition() - initialReadPosition) {
                int n;
                next = this.getNextOrAwait();
                if (next == DONE) {
                    this.cleanAndFinalize();
                    if (this.error == null) {
                        this.closed = true;
                        n = j == 0 ? -1 : j;
                        return n;
                    }
                    if (j == 0) {
                        this.closed = true;
                        throw Exceptions.propagate((Throwable)this.error);
                    }
                    n = j;
                    return n;
                }
                if (next == CLOSED) {
                    this.requiredSubscriber().cancel();
                    this.cleanAndFinalize();
                    n = -1;
                    return n;
                }
                initialReadPosition = next.readPosition();
                next.read(b, off + j, Math.min(len - j, next.readableByteCount()));
            }
            j = len;
            return j;
        }
        catch (Throwable ex) {
            this.closed = true;
            this.requiredSubscriber().cancel();
            this.cleanAndFinalize();
            throw Exceptions.propagate((Throwable)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    private DataBuffer getNextOrAwait() {
        if (this.available == null || this.available.readableByteCount() == 0) {
            this.discard(this.available);
            this.available = null;
            int actualWorkAmount = this.workAmount.getAcquire();
            while (true) {
                if (this.closed) {
                    return CLOSED;
                }
                boolean done = this.done;
                DataBuffer buffer = this.queue.poll();
                if (buffer != null) {
                    int consumed = ++this.consumed;
                    this.available = buffer;
                    if (consumed != this.limit) break;
                    this.consumed = 0;
                    this.requiredSubscriber().request((long)this.limit);
                    break;
                }
                if (done) {
                    return DONE;
                }
                if ((actualWorkAmount = this.workAmount.addAndGet(-actualWorkAmount)) != 0) continue;
                this.await();
            }
        }
        return this.available;
    }

    private void cleanAndFinalize() {
        int workAmount;
        this.discard(this.available);
        this.available = null;
        do {
            DataBuffer value;
            workAmount = this.workAmount.getPlain();
            while ((value = this.queue.poll()) != null) {
                this.discard(value);
            }
        } while (!this.workAmount.weakCompareAndSetPlain(workAmount, Integer.MIN_VALUE));
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.lock.tryLock()) {
            if (this.addWork() == 0) {
                this.resume();
            }
            return;
        }
        try {
            this.requiredSubscriber().cancel();
            this.cleanAndFinalize();
        }
        finally {
            this.lock.unlock();
        }
    }

    private Subscription requiredSubscriber() {
        Assert.state(this.subscription != null, "Subscriber must be subscribed to use InputStream");
        return this.subscription;
    }

    private void discard(@Nullable DataBuffer buffer) {
        DataBufferUtils.release(buffer);
    }

    private void await() {
        Object current;
        Thread toUnpark = Thread.currentThread();
        while ((current = this.parkedThread.get()) != READY) {
            if (current != null && current != toUnpark) {
                throw new IllegalStateException("Only one (Virtual)Thread can await!");
            }
            if (!this.parkedThread.compareAndSet(null, toUnpark)) continue;
            LockSupport.park();
        }
        this.parkedThread.lazySet(null);
    }
}

