/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.settings;

import java.nio.file.Path;
import joptsimple.OptionSet;
import org.opensearch.cli.KeyStoreAwareCommand;
import org.opensearch.cli.Terminal;
import org.opensearch.cli.UserException;
import org.opensearch.common.settings.KeyStoreWrapper;
import org.opensearch.env.Environment;

public class HasPasswordKeyStoreCommand
extends KeyStoreAwareCommand {
    static final int NO_PASSWORD_EXIT_CODE = 1;

    HasPasswordKeyStoreCommand() {
        super("Succeeds if the keystore exists and is password-protected, fails with exit code 1 otherwise.");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        Path configFile = env.configFile();
        KeyStoreWrapper keyStore = KeyStoreWrapper.load(configFile);
        if (keyStore == null) {
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "ERROR: OpenSearch keystore not found");
            throw new UserException(1, null);
        }
        if (!keyStore.hasPassword()) {
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "ERROR: Keystore is not password-protected");
            throw new UserException(1, null);
        }
        terminal.println(Terminal.Verbosity.NORMAL, "Keystore is password-protected");
    }
}

