/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.interactions.Encodable;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.SourceType;
import org.openqa.selenium.internal.Require;

public class PointerInput
implements InputSource,
Encodable {
    private final Kind kind;
    private final String name;

    public PointerInput(Kind kind, String name) {
        this.kind = Require.nonNull("Kind of pointer device", kind);
        this.name = Optional.ofNullable(name).orElse(UUID.randomUUID().toString());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SourceType getInputType() {
        return SourceType.POINTER;
    }

    @Override
    public Map<String, Object> encode() {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put("type", this.getInputType().getType());
        toReturn.put("id", this.name);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("pointerType", this.kind.getWireName());
        toReturn.put("parameters", parameters);
        return toReturn;
    }

    public Interaction createPointerMove(Duration duration, Origin origin, int x, int y) {
        return new Move(this, duration, origin, x, y);
    }

    public Interaction createPointerMove(Duration duration, Origin origin, Point offset) {
        return this.createPointerMove(duration, origin, offset.x, offset.y);
    }

    public Interaction createPointerMove(Duration duration, Origin origin, int x, int y, PointerEventProperties eventProperties) {
        return new Move(this, duration, origin, x, y, eventProperties);
    }

    public Interaction createPointerMove(Duration duration, Origin origin, Point offset, PointerEventProperties eventProperties) {
        return this.createPointerMove(duration, origin, offset.x, offset.y, eventProperties);
    }

    public Interaction createPointerDown(int button) {
        return new PointerPress((InputSource)this, PointerPress.Direction.DOWN, button);
    }

    public Interaction createPointerDown(int button, PointerEventProperties eventProperties) {
        return new PointerPress(this, PointerPress.Direction.DOWN, button, eventProperties);
    }

    public Interaction createPointerUp(int button) {
        return new PointerPress((InputSource)this, PointerPress.Direction.UP, button);
    }

    public Interaction createPointerUp(int button, PointerEventProperties eventProperties) {
        return new PointerPress(this, PointerPress.Direction.UP, button, eventProperties);
    }

    public static PointerEventProperties eventProperties() {
        return new PointerEventProperties();
    }

    public static enum Kind {
        MOUSE("mouse"),
        PEN("pen"),
        TOUCH("touch");

        private final String wireName;

        private Kind(String pointerSubType) {
            this.wireName = pointerSubType;
        }

        public String getWireName() {
            return this.wireName;
        }
    }

    private static class Move
    extends Interaction
    implements Encodable {
        private final Origin origin;
        private final int x;
        private final int y;
        private final Duration duration;
        private final PointerEventProperties eventProperties;

        protected Move(InputSource source, Duration duration, Origin origin, int x, int y, PointerEventProperties eventProperties) {
            super(source);
            this.origin = Require.nonNull("Origin of move", origin);
            this.x = x;
            this.y = y;
            this.duration = Require.nonNegative(duration);
            this.eventProperties = Require.nonNull("pointer event properties", eventProperties);
        }

        protected Move(PointerInput source, Duration duration, Origin origin, int x, int y) {
            this(source, duration, origin, x, y, new PointerEventProperties());
        }

        @Override
        protected boolean isValidFor(SourceType sourceType) {
            return SourceType.POINTER == sourceType;
        }

        @Override
        public Map<String, Object> encode() {
            Map<String, Object> toReturn = this.eventProperties.encode();
            toReturn.put("type", "pointerMove");
            toReturn.put("duration", this.duration.toMillis());
            toReturn.put("origin", this.origin.asArg());
            toReturn.put("x", this.x);
            toReturn.put("y", this.y);
            return toReturn;
        }
    }

    public static final class Origin {
        private final Object originObject;

        public Object asArg() {
            Object arg = this.originObject;
            while (arg instanceof WrapsElement) {
                arg = ((WrapsElement)arg).getWrappedElement();
            }
            return arg;
        }

        private Origin(Object originObject) {
            this.originObject = originObject;
        }

        public static Origin pointer() {
            return new Origin("pointer");
        }

        public static Origin viewport() {
            return new Origin("viewport");
        }

        public static Origin fromElement(WebElement element) {
            return new Origin(Require.nonNull("Element", element));
        }
    }

    public static class PointerEventProperties
    implements Encodable {
        private Float width = null;
        private Float height = null;
        private Float pressure = null;
        private Float tangentialPressure = null;
        private Integer tiltX = null;
        private Integer tiltY = null;
        private Integer twist = null;
        private Float altitudeAngle = null;
        private Float azimuthAngle = null;

        public PointerEventProperties setWidth(float width) {
            Require.nonNull("width", Float.valueOf(width));
            if (width < 0.0f) {
                throw new IllegalArgumentException("Width must be a positive Number");
            }
            this.width = Float.valueOf(width);
            return this;
        }

        public PointerEventProperties setHeight(float height) {
            Require.nonNull("height", Float.valueOf(height));
            if (height < 0.0f) {
                throw new IllegalArgumentException("Height must be a positive Number");
            }
            this.height = Float.valueOf(height);
            return this;
        }

        public PointerEventProperties setPressure(float pressure) {
            Require.nonNull("pressure", Float.valueOf(pressure));
            if (pressure < 0.0f || pressure > 1.0f) {
                throw new IllegalArgumentException("pressure must be a number between 0 and 1");
            }
            this.pressure = Float.valueOf(pressure);
            return this;
        }

        public PointerEventProperties setTangentialPressure(float tangentialPressure) {
            Require.nonNull("tangentialPressure", Float.valueOf(tangentialPressure));
            if (tangentialPressure < -1.0f || tangentialPressure > 1.0f) {
                throw new IllegalArgumentException("tangentialPressure must be a Number between -1 and 1");
            }
            this.tangentialPressure = Float.valueOf(tangentialPressure);
            return this;
        }

        public PointerEventProperties setTiltX(int tiltX) {
            Require.nonNull("tiltX", tiltX);
            if (tiltX < -90 || tiltX > 90) {
                throw new IllegalArgumentException("tiltX must be an integer between -90 and 90");
            }
            this.tiltX = tiltX;
            return this;
        }

        public PointerEventProperties setTiltY(int tiltY) {
            Require.nonNull("tiltY", tiltY);
            if (tiltY < -90 || tiltY > 90) {
                throw new IllegalArgumentException("tiltY must be an integer between -90 and 90");
            }
            this.tiltY = tiltY;
            return this;
        }

        public PointerEventProperties setTwist(int twist) {
            Require.nonNull("twist", twist);
            if (twist < 0 || twist > 359) {
                throw new IllegalArgumentException("twist must be an integer between 0 and 359");
            }
            this.twist = twist;
            return this;
        }

        public PointerEventProperties setAltitudeAngle(float altitudeAngle) {
            Require.nonNull("altitudeAngle", Float.valueOf(altitudeAngle));
            if (altitudeAngle < 0.0f || (double)altitudeAngle > 1.5707963267948966) {
                throw new IllegalArgumentException("altitudeAngle must be a number between 0 and \u03c0/2");
            }
            this.altitudeAngle = Float.valueOf(altitudeAngle);
            return this;
        }

        public PointerEventProperties setAzimuthAngle(float azimuthAngle) {
            Require.nonNull("azimuthAngle", Float.valueOf(azimuthAngle));
            if (azimuthAngle < 0.0f || (double)azimuthAngle > Math.PI * 2) {
                throw new IllegalArgumentException("azimuthAngle must be a number between 0 and 2\u03c0");
            }
            this.azimuthAngle = Float.valueOf(azimuthAngle);
            return this;
        }

        @Override
        public Map<String, Object> encode() {
            HashMap<String, Object> toReturn = new HashMap<String, Object>();
            Optional.ofNullable(this.width).ifPresent(v -> toReturn.put("width", v));
            Optional.ofNullable(this.height).ifPresent(v -> toReturn.put("height", v));
            Optional.ofNullable(this.pressure).ifPresent(v -> toReturn.put("pressure", v));
            Optional.ofNullable(this.tangentialPressure).ifPresent(v -> toReturn.put("tangentialPressure", v));
            Optional.ofNullable(this.tiltX).ifPresent(v -> toReturn.put("tiltX", v));
            Optional.ofNullable(this.tiltY).ifPresent(v -> toReturn.put("tiltY", v));
            Optional.ofNullable(this.twist).ifPresent(v -> toReturn.put("twist", v));
            Optional.ofNullable(this.altitudeAngle).ifPresent(v -> toReturn.put("altitudeAngle", v));
            Optional.ofNullable(this.azimuthAngle).ifPresent(v -> toReturn.put("azimuthAngle", v));
            return toReturn;
        }
    }

    private static class PointerPress
    extends Interaction
    implements Encodable {
        private final Direction direction;
        private final int button;
        private final PointerEventProperties eventProperties;

        public PointerPress(InputSource source, Direction direction, int button) {
            super(source);
            if (button < 0) {
                throw new IllegalStateException(String.format("Button must be greater than or equal to 0: %d", button));
            }
            this.direction = Require.nonNull("Direction of move", direction);
            this.button = button;
            this.eventProperties = new PointerEventProperties();
        }

        @Deprecated
        public PointerPress(InputSource source, Direction direction, PointerEventProperties eventProperties) {
            this(source, direction, 0, eventProperties);
        }

        public PointerPress(InputSource source, Direction direction, int button, PointerEventProperties eventProperties) {
            super(source);
            this.button = button;
            this.eventProperties = Require.nonNull("pointer event properties", eventProperties);
            this.direction = Require.nonNull("Direction of press", direction);
        }

        @Override
        public Map<String, Object> encode() {
            Map<String, Object> toReturn = this.eventProperties.encode();
            toReturn.put("type", this.direction.getType());
            toReturn.put("button", this.button);
            return toReturn;
        }

        static enum Direction {
            DOWN("pointerDown"),
            UP("pointerUp");

            private final String type;

            private Direction(String type) {
                this.type = type;
            }

            public String getType() {
                return this.type;
            }
        }
    }

    public static enum MouseButton {
        LEFT(0),
        MIDDLE(1),
        RIGHT(2),
        BACK(3),
        FORWARD(4);

        private final int button;

        private MouseButton(int button) {
            this.button = button;
        }

        public int asArg() {
            return this.button;
        }
    }
}

