/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth.oauth2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.client.api.AuthenticationDataProvider;

class AuthenticationDataOAuth2
implements AuthenticationDataProvider {
    public static final String HTTP_HEADER_NAME = "Authorization";
    private final String accessToken;
    private Map<String, String> headers = new HashMap<String, String>();

    public AuthenticationDataOAuth2(String accessToken) {
        this.accessToken = accessToken;
        this.headers.put(HTTP_HEADER_NAME, "Bearer " + accessToken);
        this.headers.put("X-Pulsar-Auth-Method-Name", "token");
        this.headers = Collections.unmodifiableMap(this.headers);
    }

    public boolean hasDataForHttp() {
        return true;
    }

    public Set<Map.Entry<String, String>> getHttpHeaders() {
        return this.headers.entrySet();
    }

    public boolean hasDataFromCommand() {
        return true;
    }

    public String getCommandData() {
        return this.accessToken;
    }
}

