/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.numeric;

import java.math.BigDecimal;
import java.util.List;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class AbsExpression<T>
extends AbstractFunctionExpression<T, Number> {
    private final FunctionParameterTypePredicate<Number> _typeValidator = FunctionParameterTypePredicate.builder().allowNumbers().build();

    public AbsExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireParameters(1, args, this);
    }

    @Override
    public Number apply(T value) {
        Number arg = this.evaluateChild(0, value, this._typeValidator);
        return (Number)NumberConverter.narrow(new BigDecimal(arg.toString()).abs());
    }
}

