/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.pipeline;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Context;
import io.grpc.Metadata;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.constant.GrpcConstants;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.grpc.pipeline.RequestPipeline;
import org.apache.rocketmq.proxy.processor.channel.ChannelProtocolType;

public class ContextInitPipeline
implements RequestPipeline {
    @Override
    public void execute(ProxyContext context, Metadata headers, GeneratedMessageV3 request) {
        Context ctx = Context.current();
        context.setLocalAddress(this.getDefaultStringMetadataInfo(headers, (Metadata.Key<String>)GrpcConstants.LOCAL_ADDRESS)).setRemoteAddress(this.getDefaultStringMetadataInfo(headers, (Metadata.Key<String>)GrpcConstants.REMOTE_ADDRESS)).setClientID(this.getDefaultStringMetadataInfo(headers, (Metadata.Key<String>)GrpcConstants.CLIENT_ID)).setProtocolType(ChannelProtocolType.GRPC_V2.getName()).setLanguage(this.getDefaultStringMetadataInfo(headers, (Metadata.Key<String>)GrpcConstants.LANGUAGE)).setClientVersion(this.getDefaultStringMetadataInfo(headers, (Metadata.Key<String>)GrpcConstants.CLIENT_VERSION)).setAction(this.getDefaultStringMetadataInfo(headers, (Metadata.Key<String>)GrpcConstants.SIMPLE_RPC_NAME)).setNamespace(this.getDefaultStringMetadataInfo(headers, (Metadata.Key<String>)GrpcConstants.NAMESPACE_ID));
        if (ctx.getDeadline() != null) {
            context.setRemainingMs(ctx.getDeadline().timeRemaining(TimeUnit.MILLISECONDS));
        }
    }

    protected String getDefaultStringMetadataInfo(Metadata headers, Metadata.Key<String> key) {
        return StringUtils.defaultString((String)((String)headers.get(key)));
    }
}

