/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.analyser;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.extension.apiregions.api.ApiExport;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.extension.apiregions.api.DeprecationInfo;
import org.apache.sling.feature.extension.apiregions.api.DeprecationValidationMode;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class CheckDeprecatedApi
implements AnalyserTask {
    public static final String CFG_REGIONS = "regions";
    private static final String CFG_STRICT = "strict";
    private static final String CFG_REMOVAL_PERIOD = "removal-period";
    private static final String CFG_CHECK_OPTIONAL_IMPORTS = "check-optional-imports";

    public String getId() {
        return "region-deprecated-api";
    }

    public String getName() {
        return "Region Deprecated API analyser task";
    }

    public void execute(AnalyserTaskContext context) throws Exception {
        ApiRegions regions = ApiRegions.getApiRegions(context.getFeature());
        if (regions == null) {
            context.reportExtensionError("api-regions", "No regions configured");
        } else {
            Map<BundleDescriptor, Set<String>> bundleRegions = this.calculateBundleRegions(context, regions);
            boolean strict = Boolean.parseBoolean(context.getConfiguration().getOrDefault(CFG_STRICT, "false"));
            Integer removalPeriod = Integer.parseInt(context.getConfiguration().getOrDefault(CFG_REMOVAL_PERIOD, "-1"));
            boolean checkOptionalImports = Boolean.parseBoolean(context.getConfiguration().getOrDefault(CFG_CHECK_OPTIONAL_IMPORTS, "false"));
            String regionNames = context.getConfiguration().getOrDefault(CFG_REGIONS, "global");
            for (String r : regionNames.split(",")) {
                ApiRegion region = regions.getRegionByName(r.trim());
                if (region == null) {
                    context.reportExtensionError("api-regions", "Region not found:" + r.trim());
                    continue;
                }
                this.checkBundlesForRegion(context, region, bundleRegions, strict, removalPeriod, checkOptionalImports);
            }
        }
    }

    private Map<BundleDescriptor, Set<String>> calculateBundleRegions(AnalyserTaskContext context, ApiRegions regions) {
        LinkedHashMap<BundleDescriptor, Set<String>> result = new LinkedHashMap<BundleDescriptor, Set<String>>();
        for (BundleDescriptor bd : context.getFeatureDescriptor().getBundleDescriptors()) {
            Set<String> regionNames = this.getBundleRegions(bd, regions);
            result.put(bd, regionNames);
        }
        return result;
    }

    private void checkBundlesForRegion(AnalyserTaskContext context, ApiRegion region, Map<BundleDescriptor, Set<String>> bundleRegions, boolean strict, int removalPeriod, boolean checkOptionalImports) {
        Calendar checkDate;
        if (removalPeriod > 0) {
            checkDate = Calendar.getInstance();
            checkDate.set(11, 23);
            checkDate.set(12, 59);
            checkDate.add(6, removalPeriod);
        } else {
            checkDate = null;
        }
        Map<String, DeprecatedPackage> deprecatedPackages = this.calculateDeprecatedPackages(region, bundleRegions);
        Set<String> allowedNames = this.getAllowedRegions(region);
        for (BundleDescriptor bd : context.getFeatureDescriptor().getBundleDescriptors()) {
            if (!this.isInAllowedRegion(bundleRegions.get(bd), region.getName(), allowedNames)) continue;
            for (PackageInfo pi : bd.getImportedPackages()) {
                if (!checkOptionalImports && pi.isOptional()) continue;
                DeprecationInfo deprecationInfo = null;
                DeprecatedPackage deprecatedPackage = deprecatedPackages.get(pi.getName());
                if (deprecatedPackage != null) {
                    deprecationInfo = deprecatedPackage.isDeprecated(pi);
                }
                if (deprecationInfo == null) continue;
                String msg = "Usage of deprecated package found : ".concat(pi.getName()).concat(" : ").concat(deprecationInfo.getMessage());
                if (deprecationInfo.getSince() != null) {
                    msg = msg.concat(" Deprecated since ").concat(deprecationInfo.getSince());
                }
                boolean isError = deprecationInfo.getMode() != null ? deprecationInfo.getMode() == DeprecationValidationMode.STRICT : strict;
                if (deprecationInfo.isForRemoval()) {
                    Calendar c;
                    boolean printRemoval = true;
                    if (checkDate != null && (c = deprecationInfo.getForRemovalBy()) != null && c.before(checkDate)) {
                        isError = true;
                        printRemoval = false;
                        msg = msg.concat(" The package is scheduled to be removed in less than ").concat(String.valueOf(removalPeriod)).concat(" days by ").concat(deprecationInfo.getForRemoval());
                    }
                    if (printRemoval) {
                        msg = msg.concat(" For removal : ").concat(deprecationInfo.getForRemoval());
                    }
                }
                if (isError) {
                    context.reportArtifactError(bd.getArtifact().getId(), msg);
                    continue;
                }
                context.reportArtifactWarning(bd.getArtifact().getId(), msg);
            }
        }
    }

    boolean isInAllowedRegion(Set<String> bundleRegions, String regionName, Set<String> allowedRegions) {
        if (bundleRegions.contains(regionName)) {
            for (String name : bundleRegions) {
                if (allowedRegions.contains(name)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    Set<String> getAllowedRegions(ApiRegion region) {
        HashSet<String> allowedNames = new HashSet<String>();
        for (ApiRegion r = region; r != null; r = r.getParent()) {
            allowedNames.add(r.getName());
        }
        return allowedNames;
    }

    Map<String, DeprecatedPackage> calculateDeprecatedPackages(ApiRegion region, Map<BundleDescriptor, Set<String>> bundleRegions) {
        HashMap<String, DeprecatedPackage> result = new HashMap<String, DeprecatedPackage>();
        for (ApiRegion current = region; current != null; current = current.getParent()) {
            for (ApiExport export : current.listExports()) {
                if (export.getDeprecation().getPackageInfo() == null || result.containsKey(export.getName())) continue;
                DeprecatedPackage pck = this.getDeprecatedPackage(bundleRegions, current, export);
                result.put(export.getName(), pck);
            }
        }
        return result;
    }

    DeprecatedPackage getDeprecatedPackage(Map<BundleDescriptor, Set<String>> bundleRegions, ApiRegion region, ApiExport export) {
        ArrayList<PackageInfo> deprecatedList = new ArrayList<PackageInfo>();
        ArrayList<PackageInfo> nonDeprecatedList = new ArrayList<PackageInfo>();
        ArtifactId[] regionOrigins = region.getFeatureOrigins();
        for (Map.Entry<BundleDescriptor, Set<String>> entry : bundleRegions.entrySet()) {
            ArtifactId[] bundleOrigins = entry.getKey().getArtifact().getFeatureOrigins();
            if (!entry.getValue().contains(region.getName())) continue;
            for (PackageInfo info : entry.getKey().getExportedPackages()) {
                if (!info.getName().equals(export.getName())) continue;
                if (regionOrigins.length == 0 || bundleOrigins.length > 0 && bundleOrigins[0].isSame(regionOrigins[0])) {
                    deprecatedList.add(info);
                    continue;
                }
                nonDeprecatedList.add(info);
            }
        }
        return new DeprecatedPackage(export.getDeprecation().getPackageInfo(), deprecatedList, nonDeprecatedList);
    }

    private Set<String> getBundleRegions(BundleDescriptor info, ApiRegions regions) {
        return Stream.of(info.getArtifact().getFeatureOrigins()).map(regions::getRegionsByFeature).flatMap(Stream::of).map(ApiRegion::getName).collect(Collectors.toSet());
    }

    static final class DeprecatedPackage {
        private final DeprecationInfo deprecationInfo;
        private final List<PackageInfo> deprecatedList;
        private final List<PackageInfo> nonDeprecatedList;

        public DeprecationInfo getDeprecationInfo() {
            return this.deprecationInfo;
        }

        public DeprecatedPackage(DeprecationInfo deprecationInfo, List<PackageInfo> deprecatedList, List<PackageInfo> nonDeprecatedList) {
            this.deprecationInfo = deprecationInfo;
            this.deprecatedList = deprecatedList;
            this.nonDeprecatedList = nonDeprecatedList;
        }

        public DeprecationInfo isDeprecated(PackageInfo pi) {
            Version exportVersion;
            VersionRange importVersion = pi.getVersion() != null ? pi.getPackageVersionRange() : null;
            for (PackageInfo nonDeprecated : this.nonDeprecatedList) {
                exportVersion = nonDeprecated.getPackageVersion();
                if (exportVersion != null && importVersion != null && !importVersion.includes(exportVersion)) continue;
                return null;
            }
            for (PackageInfo deprecated : this.deprecatedList) {
                exportVersion = deprecated.getPackageVersion();
                if (exportVersion != null && importVersion != null && !importVersion.includes(exportVersion)) continue;
                return this.deprecationInfo;
            }
            return null;
        }
    }
}

