/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Collections;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.impl.via.BeanPropertyViaProvider;
import org.apache.sling.models.impl.via.ChildResourceViaProvider;
import org.apache.sling.models.spi.ViaProvider;
import org.apache.sling.models.testmodels.classes.ChildResourceViaModel;
import org.apache.sling.models.testmodels.classes.ViaModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ViaTest {
    @Mock
    private Resource resource;
    @Mock
    private Resource childResource;
    @Mock
    private SlingJakartaHttpServletRequest request;
    private ModelAdapterFactory factory;

    ViaTest() {
    }

    @BeforeEach
    void setup() {
        Mockito.lenient().when((Object)this.request.getResource()).thenReturn((Object)this.resource);
        Mockito.lenient().when((Object)this.resource.getChild("jcr:content")).thenReturn((Object)this.childResource);
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Collections.singletonList(new ValueMapInjector());
        this.factory.bindViaProvider((ViaProvider)new BeanPropertyViaProvider(), null);
        this.factory.bindViaProvider((ViaProvider)new ChildResourceViaProvider(), null);
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{ViaModel.class});
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{ChildResourceViaModel.class});
    }

    @Test
    void testProjectionToResource() {
        String value = RandomStringUtils.secure().nextAlphanumeric(10);
        ValueMapDecorator map = new ValueMapDecorator(Collections.singletonMap("firstProperty", value));
        Mockito.when((Object)((ValueMap)this.resource.adaptTo(ValueMap.class))).thenReturn((Object)map);
        ViaModel model = (ViaModel)this.factory.getAdapter((Object)this.request, ViaModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)value, (Object)model.getFirstProperty());
    }

    @Test
    void testProjectionToChildResource() {
        String value = RandomStringUtils.secure().nextAlphanumeric(10);
        ValueMapDecorator map = new ValueMapDecorator(Collections.singletonMap("firstProperty", value));
        Mockito.when((Object)((ValueMap)this.childResource.adaptTo(ValueMap.class))).thenReturn((Object)map);
        ChildResourceViaModel model = (ChildResourceViaModel)this.factory.getAdapter((Object)this.resource, ChildResourceViaModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)value, (Object)model.getFirstProperty());
    }
}

