/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;

public class Aggregate
extends FeatureSelectionConfig {
    public String classifier;
    public boolean attach = true;
    public boolean markAsFinal = false;
    public boolean markAsComplete = false;
    public String title;
    public String description;
    public String vendor;
    public List<String> artifactsOverrides;
    public List<String> configurationOverrides;
    public Map<String, String> variablesOverrides;
    public Map<String, String> frameworkPropertiesOverrides;

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.artifactsOverrides, this.attach, this.classifier, this.configurationOverrides, this.description, this.frameworkPropertiesOverrides, this.markAsComplete, this.markAsFinal, this.title, this.variablesOverrides, this.vendor);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Aggregate other = (Aggregate)obj;
        return Objects.equals(this.artifactsOverrides, other.artifactsOverrides) && this.attach == other.attach && Objects.equals(this.classifier, other.classifier) && Objects.equals(this.configurationOverrides, other.configurationOverrides) && Objects.equals(this.description, other.description) && Objects.equals(this.frameworkPropertiesOverrides, other.frameworkPropertiesOverrides) && this.markAsComplete == other.markAsComplete && this.markAsFinal == other.markAsFinal && Objects.equals(this.title, other.title) && Objects.equals(this.variablesOverrides, other.variablesOverrides) && Objects.equals(this.vendor, other.vendor);
    }

    @Override
    public String toString() {
        return "Aggregate [selection=" + String.valueOf(this.getSelections()) + ", filesExcludes=" + String.valueOf(this.getFilesExcludes()) + ", classifier=" + this.classifier + ", attach=" + this.attach + ", markAsFinal=" + this.markAsFinal + ", markAsComplete=" + this.markAsComplete + ", title=" + this.title + ", description=" + this.description + ", vendor=" + this.vendor + ", artifactsOverrides=" + String.valueOf(this.artifactsOverrides) + ", variablesOverrides=" + String.valueOf(this.variablesOverrides) + ", frameworkPropertiesOverrides=" + String.valueOf(this.frameworkPropertiesOverrides) + "]";
    }

    public List<ArtifactId> getArtifactOverrideRules() {
        if (this.artifactsOverrides == null) {
            return Collections.emptyList();
        }
        return this.artifactsOverrides.stream().map(r -> ArtifactId.parse((String)r)).collect(Collectors.toList());
    }

    public Map<String, String> getConfigurationOverrideRules() {
        if (this.configurationOverrides == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String entry : this.configurationOverrides) {
            int idx = entry.lastIndexOf("=");
            if (idx == -1) continue;
            result.put(entry.substring(0, idx), entry.substring(idx + 1));
        }
        return result;
    }
}

