/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.zookeeper;

import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.callback.DefaultWatcherCallBack;
import org.apache.storm.callback.WatcherCallBack;
import org.apache.storm.cluster.ClusterUtils;
import org.apache.storm.cluster.DaemonType;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.WorkerTokenServiceType;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.security.auth.NimbusPrincipal;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.storm.shade.org.apache.curator.framework.api.BackgroundPathable;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.shade.org.apache.zookeeper.data.Id;
import org.apache.storm.shade.org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.Utils;
import org.apache.storm.zookeeper.ClientZookeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclEnforcement {
    private static final Logger LOG = LoggerFactory.getLogger(AclEnforcement.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyAcls(Map<String, Object> conf, boolean fixUp) throws Exception {
        CuratorFramework zk;
        String stormRoot;
        int port;
        List zkServers;
        ArrayList<ACL> drpcFullAcl;
        ArrayList<ACL> superAcl;
        ACL superUserAcl;
        block34: {
            if (!Utils.isZkAuthenticationConfiguredStormServer(conf)) {
                LOG.info("SECURITY IS DISABLED NO FURTHER CHECKS...");
                return;
            }
            superUserAcl = Utils.getSuperUserAcl(conf);
            superAcl = new ArrayList<ACL>(1);
            superAcl.add(superUserAcl);
            drpcFullAcl = new ArrayList<ACL>(2);
            drpcFullAcl.add(superUserAcl);
            String drpcAclString = (String)conf.get("storm.zookeeper.drpcACL");
            if (drpcAclString != null) {
                Id drpcAclId = Utils.parseZkId((String)drpcAclString, (String)"storm.zookeeper.drpcACL");
                ACL drpcUserAcl = new ACL(1, drpcAclId);
                drpcFullAcl.add(drpcUserAcl);
            }
            zkServers = (List)conf.get("storm.zookeeper.servers");
            port = ObjectReader.getInt((Object)conf.get("storm.zookeeper.port"));
            stormRoot = (String)conf.get("storm.zookeeper.root");
            zk = ClientZookeeper.mkClient(conf, (List)zkServers, (Object)port, (String)"", (WatcherCallBack)new DefaultWatcherCallBack(), conf, (DaemonType)DaemonType.NIMBUS);
            try {
                if (zk.checkExists().forPath(stormRoot) != null) {
                    AclEnforcement.verifyAclStrict(zk, superAcl, stormRoot, fixUp);
                    break block34;
                }
                LOG.warn("{} does not exist no need to check any more...", (Object)stormRoot);
                return;
            }
            finally {
                if (zk != null) {
                    zk.close();
                }
            }
        }
        zk = ClientZookeeper.mkClient(conf, (List)zkServers, (Object)port, (String)stormRoot, (WatcherCallBack)new DefaultWatcherCallBack(), conf, (DaemonType)DaemonType.NIMBUS);
        try {
            if (zk.checkExists().forPath("/blobstore") != null) {
                AclEnforcement.verifyAclStrictRecursive(zk, superAcl, "/blobstore", fixUp);
            }
            if (zk.checkExists().forPath("/blobstoremaxkeysequencenumber") != null) {
                AclEnforcement.verifyAclStrict(zk, superAcl, "/blobstoremaxkeysequencenumber", fixUp);
            }
            HashSet topoIds = new HashSet();
            if (zk.checkExists().forPath("/storms") != null) {
                topoIds.addAll((Collection)zk.getChildren().forPath("/storms"));
            }
            HashMap<String, Id> topoToZkCreds = new HashMap<String, Id>();
            BlobStore bs = ServerUtils.getNimbusBlobStore(conf, NimbusInfo.fromConf(conf), null);
            try {
                Subject nimbusSubject = new Subject();
                nimbusSubject.getPrincipals().add((Principal)new NimbusPrincipal());
                for (String topoId : topoIds) {
                    try {
                        String blobKey = topoId + "-stormconf.ser";
                        Map topoConf = Utils.fromCompressedJsonConf((byte[])bs.readBlob(blobKey, nimbusSubject));
                        String payload = (String)topoConf.get("storm.zookeeper.topology.auth.payload");
                        try {
                            topoToZkCreds.put(topoId, new Id("digest", DigestAuthenticationProvider.generateDigest((String)payload)));
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (KeyNotFoundException knf) {
                        LOG.debug("topo removed {}", (Object)topoId, (Object)knf);
                    }
                }
            }
            finally {
                if (bs != null) {
                    bs.shutdown();
                }
            }
            AclEnforcement.verifyParentWithReadOnlyTopoChildren(zk, superUserAcl, "/storms", topoToZkCreds, fixUp);
            AclEnforcement.verifyParentWithReadOnlyTopoChildren(zk, superUserAcl, "/assignments", topoToZkCreds, fixUp);
            AclEnforcement.verifyParentWithReadOnlyTopoChildrenDeleteDead(zk, superUserAcl, "/credentials", topoToZkCreds, fixUp);
            AclEnforcement.verifyParentWithReadOnlyTopoChildrenDeleteDead(zk, superUserAcl, "/logconfigs", topoToZkCreds, fixUp);
            AclEnforcement.verifyParentWithReadWriteTopoChildrenDeleteDead(zk, superUserAcl, "/backpressure", topoToZkCreds, fixUp);
            if (zk.checkExists().forPath("/errors") != null) {
                for (String topoId : topoToZkCreds.keySet()) {
                    String path = ClusterUtils.errorStormRoot((String)topoId);
                    if (zk.checkExists().forPath(path) != null) continue;
                    LOG.warn("Creating missing errors location {}", (Object)path);
                    ((BackgroundPathAndBytesable)zk.create().withACL(AclEnforcement.getTopoReadWrite(path, topoId, topoToZkCreds, superUserAcl, fixUp))).forPath(path);
                }
            }
            AclEnforcement.verifyParentWithReadWriteTopoChildrenDeleteDead(zk, superUserAcl, "/errors", topoToZkCreds, fixUp);
            if (zk.checkExists().forPath("/secretkeys") != null) {
                AclEnforcement.verifyAclStrict(zk, superAcl, "/secretkeys", fixUp);
                AclEnforcement.verifyAclStrictRecursive(zk, superAcl, ClusterUtils.secretKeysPath((WorkerTokenServiceType)WorkerTokenServiceType.NIMBUS), fixUp);
                AclEnforcement.verifyAclStrictRecursive(zk, drpcFullAcl, ClusterUtils.secretKeysPath((WorkerTokenServiceType)WorkerTokenServiceType.DRPC), fixUp);
            }
            if (zk.checkExists().forPath("/nimbuses") != null) {
                AclEnforcement.verifyAclStrictRecursive(zk, superAcl, "/nimbuses", fixUp);
            }
            if (zk.checkExists().forPath("/leader-lock") != null) {
                AclEnforcement.verifyAclStrictRecursive(zk, superAcl, "/leader-lock", fixUp);
            }
            if (zk.checkExists().forPath("/profilerconfigs") != null) {
                AclEnforcement.verifyAclStrictRecursive(zk, superAcl, "/profilerconfigs", fixUp);
            }
            if (zk.checkExists().forPath("/supervisors") != null) {
                AclEnforcement.verifyAclStrictRecursive(zk, superAcl, "/supervisors", fixUp);
            }
            AclEnforcement.verifyParentWithReadWriteTopoChildrenDeleteDead(zk, superUserAcl, "/workerbeats", topoToZkCreds, fixUp);
        }
        finally {
            if (zk != null) {
                zk.close();
            }
        }
    }

    private static List<ACL> getTopoAcl(String path, String topoId, Map<String, Id> topoToZkCreds, ACL superAcl, boolean fixUp, int perms) {
        Id id = topoToZkCreds.get(topoId);
        if (id == null) {
            String error = "Could not find credentials for topology " + topoId + " at path " + path + ".";
            if (fixUp) {
                error = error + " Don't know how to fix this automatically. Please add needed ACLs, or delete the path.";
            }
            throw new IllegalStateException(error);
        }
        ArrayList<ACL> ret = new ArrayList<ACL>(2);
        ret.add(superAcl);
        ret.add(new ACL(perms, id));
        return ret;
    }

    private static List<ACL> getTopoReadWrite(String path, String topoId, Map<String, Id> topoToZkCreds, ACL superAcl, boolean fixUp) {
        return AclEnforcement.getTopoAcl(path, topoId, topoToZkCreds, superAcl, fixUp, 31);
    }

    private static void verifyParentWithTopoChildrenDeleteDead(CuratorFramework zk, ACL superUserAcl, String path, Map<String, Id> topoToZkCreds, boolean fixUp, int perms) throws Exception {
        if (zk.checkExists().forPath(path) != null) {
            String childPath;
            AclEnforcement.verifyAclStrict(zk, Arrays.asList(superUserAcl), path, fixUp);
            HashSet<String> possiblyBadIds = new HashSet<String>();
            for (String topoId : (List)zk.getChildren().forPath(path)) {
                childPath = path + "/" + topoId;
                if (!topoToZkCreds.containsKey(topoId)) {
                    possiblyBadIds.add(topoId);
                    continue;
                }
                List<ACL> rwAcl = AclEnforcement.getTopoAcl(path, topoId, topoToZkCreds, superUserAcl, fixUp, perms);
                AclEnforcement.verifyAclStrictRecursive(zk, rwAcl, childPath, fixUp);
            }
            if (!possiblyBadIds.isEmpty()) {
                possiblyBadIds.removeAll((Collection)zk.getChildren().forPath("/storms"));
                for (String topoId : possiblyBadIds) {
                    childPath = path + "/" + topoId;
                    zk.delete().deletingChildrenIfNeeded().forPath(childPath);
                }
            }
        }
    }

    private static void verifyParentWithReadOnlyTopoChildrenDeleteDead(CuratorFramework zk, ACL superUserAcl, String path, Map<String, Id> topoToZkCreds, boolean fixUp) throws Exception {
        AclEnforcement.verifyParentWithTopoChildrenDeleteDead(zk, superUserAcl, path, topoToZkCreds, fixUp, 1);
    }

    private static void verifyParentWithReadWriteTopoChildrenDeleteDead(CuratorFramework zk, ACL superUserAcl, String path, Map<String, Id> topoToZkCreds, boolean fixUp) throws Exception {
        AclEnforcement.verifyParentWithTopoChildrenDeleteDead(zk, superUserAcl, path, topoToZkCreds, fixUp, 31);
    }

    private static void verifyParentWithTopoChildren(CuratorFramework zk, ACL superUserAcl, String path, Map<String, Id> topoToZkCreds, boolean fixUp, int perms) throws Exception {
        if (zk.checkExists().forPath(path) != null) {
            AclEnforcement.verifyAclStrict(zk, Arrays.asList(superUserAcl), path, fixUp);
            for (String topoId : (List)zk.getChildren().forPath(path)) {
                String childPath = path + "/" + topoId;
                List<ACL> rwAcl = AclEnforcement.getTopoAcl(path, topoId, topoToZkCreds, superUserAcl, fixUp, perms);
                AclEnforcement.verifyAclStrictRecursive(zk, rwAcl, childPath, fixUp);
            }
        }
    }

    private static void verifyParentWithReadOnlyTopoChildren(CuratorFramework zk, ACL superUserAcl, String path, Map<String, Id> topoToZkCreds, boolean fixUp) throws Exception {
        AclEnforcement.verifyParentWithTopoChildren(zk, superUserAcl, path, topoToZkCreds, fixUp, 1);
    }

    private static void verifyParentWithReadWriteTopoChildren(CuratorFramework zk, ACL superUserAcl, String path, Map<String, Id> topoToZkCreds, boolean fixUp) throws Exception {
        AclEnforcement.verifyParentWithTopoChildren(zk, superUserAcl, path, topoToZkCreds, fixUp, 31);
    }

    private static void verifyAclStrictRecursive(CuratorFramework zk, List<ACL> strictAcl, String path, boolean fixUp) throws Exception {
        AclEnforcement.verifyAclStrict(zk, strictAcl, path, fixUp);
        for (String child : (List)zk.getChildren().forPath(path)) {
            String newPath = path + "/" + child;
            AclEnforcement.verifyAclStrictRecursive(zk, strictAcl, newPath, fixUp);
        }
    }

    private static void verifyAclStrict(CuratorFramework zk, List<ACL> strictAcl, String path, boolean fixUp) throws Exception {
        block3: {
            try {
                List foundAcl = (List)zk.getACL().forPath(path);
                if (AclEnforcement.equivalent(foundAcl, strictAcl)) break block3;
                if (fixUp) {
                    LOG.warn("{} expected to have ACL {}, but has {}.  Fixing...", new Object[]{path, strictAcl, foundAcl});
                    ((BackgroundPathable)zk.setACL().withACL(strictAcl)).forPath(path);
                    break block3;
                }
                throw new IllegalStateException(path + " did not have the correct ACL found " + String.valueOf(foundAcl) + " expected " + String.valueOf(strictAcl));
            }
            catch (KeeperException.NoNodeException ne) {
                LOG.debug("{} removed in the middle of checking it", (Throwable)ne);
            }
        }
    }

    private static boolean equivalent(List<ACL> a, List<ACL> b) {
        if (a.size() == b.size()) {
            for (ACL acl : a) {
                if (b.contains(acl)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        Map conf = ConfigUtils.readStormConfig();
        boolean fixUp = false;
        for (String arg : args) {
            String a = arg.toLowerCase();
            if (!"-f".equals(a) && !"--fixup".equals(a)) {
                throw new IllegalArgumentException("Unsupported argument " + arg + " only -f or --fixup is supported.");
            }
            fixUp = true;
        }
        AclEnforcement.verifyAcls(conf, fixUp);
    }
}

