/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import com.codahale.metrics.Gauge;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.metric.internal.RateTracker;
import org.apache.storm.metrics2.StormMetricRegistry;
import org.apache.storm.shade.org.jctools.queues.MpscArrayQueue;
import org.apache.storm.shade.org.jctools.queues.MpscUnboundedArrayQueue;

public class JCQueueMetrics
implements Closeable {
    private final RateTracker arrivalsTracker = new RateTracker(10000, 10);
    private final RateTracker insertFailuresTracker = new RateTracker(10000, 10);
    private final AtomicLong droppedMessages = new AtomicLong(0L);

    public JCQueueMetrics(String metricNamePrefix, String topologyId, String componentId, int taskId, int port, StormMetricRegistry metricRegistry, final MpscArrayQueue<Object> receiveQ, final MpscUnboundedArrayQueue<Object> overflowQ) {
        Gauge<Integer> cap = new Gauge<Integer>(){

            public Integer getValue() {
                return receiveQ.capacity();
            }
        };
        Gauge<Float> pctFull = new Gauge<Float>(){

            public Float getValue() {
                return Float.valueOf(1.0f * (float)receiveQ.size() / (float)receiveQ.capacity());
            }
        };
        Gauge<Integer> pop = new Gauge<Integer>(){

            public Integer getValue() {
                return receiveQ.size();
            }
        };
        Gauge<Double> arrivalRate = new Gauge<Double>(){

            public Double getValue() {
                return JCQueueMetrics.this.arrivalsTracker.reportRate();
            }
        };
        Gauge<Double> sojourn = new Gauge<Double>(){

            public Double getValue() {
                return (double)receiveQ.size() / Math.max(JCQueueMetrics.this.arrivalsTracker.reportRate(), 1.0E-5) * 1000.0;
            }
        };
        Gauge<Double> insertFailures = new Gauge<Double>(){

            public Double getValue() {
                return JCQueueMetrics.this.insertFailuresTracker.reportRate();
            }
        };
        Gauge<Long> dropped = new Gauge<Long>(){

            public Long getValue() {
                return JCQueueMetrics.this.droppedMessages.get();
            }
        };
        Gauge<Integer> overflow = new Gauge<Integer>(){

            public Integer getValue() {
                return overflowQ.size();
            }
        };
        metricRegistry.gauge(metricNamePrefix + "-capacity", cap, topologyId, componentId, (Integer)taskId, (Integer)port);
        metricRegistry.gauge(metricNamePrefix + "-pct_full", pctFull, topologyId, componentId, (Integer)taskId, (Integer)port);
        metricRegistry.gauge(metricNamePrefix + "-population", pop, topologyId, componentId, (Integer)taskId, (Integer)port);
        metricRegistry.gauge(metricNamePrefix + "-arrival_rate_secs", arrivalRate, topologyId, componentId, (Integer)taskId, (Integer)port);
        metricRegistry.gauge(metricNamePrefix + "-sojourn_time_ms", sojourn, topologyId, componentId, (Integer)taskId, (Integer)port);
        metricRegistry.gauge(metricNamePrefix + "-insert_failures", insertFailures, topologyId, componentId, (Integer)taskId, (Integer)port);
        metricRegistry.gauge(metricNamePrefix + "-dropped_messages", dropped, topologyId, componentId, (Integer)taskId, (Integer)port);
        metricRegistry.gauge(metricNamePrefix + "-overflow", overflow, topologyId, componentId, (Integer)taskId, (Integer)port);
    }

    public void notifyArrivals(long counts) {
        this.arrivalsTracker.notify(counts);
    }

    public void notifyInsertFailure() {
        this.insertFailuresTracker.notify(1L);
    }

    public void notifyDroppedMsg() {
        this.droppedMessages.incrementAndGet();
    }

    @Override
    public void close() {
        this.arrivalsTracker.close();
        this.insertFailuresTracker.close();
    }
}

