/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.Header;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.client.RedirectURIValidator;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMatchingStrategy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.services.query.RegisteredServiceQuery;
import org.apereo.cas.support.oauth.OAuth20ClientAuthenticationMethods;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public final class OAuth20Utils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20Utils.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().singleArrayElementUnwrapped(true).build().toObjectMapper();

    public static ModelAndView writeError(HttpServletResponse response, String error) {
        return OAuth20Utils.writeError(response, error, null);
    }

    public static ModelAndView writeError(HttpServletResponse response, String error, String description) {
        Map<String, Object> model = OAuth20Utils.getErrorResponseBody(error, description);
        ModelAndView mv = new ModelAndView((View)new MappingJackson2JsonView(MAPPER), model);
        mv.setStatus((HttpStatusCode)HttpStatus.BAD_REQUEST);
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        return mv;
    }

    public static Map<String, Object> getErrorResponseBody(String error, String description) {
        Map model = CollectionUtils.wrap((String)"error", (Object)error);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            model.put("error_description", description);
        }
        return model;
    }

    public static <T extends OAuthRegisteredService> T getRegisteredOAuthServiceByClientId(ServicesManager servicesManager, String clientId, Class<T> clazz) {
        return (T)((OAuthRegisteredService)FunctionUtils.doIfNotBlank((CharSequence)clientId, () -> {
            RegisteredServiceQuery query = RegisteredServiceQuery.of(OAuthRegisteredService.class, (String)"clientId", (Object)clientId).withIncludeAssignableTypes(true);
            return servicesManager.findServicesBy(new RegisteredServiceQuery[]{query}).findFirst().map(clazz::cast).orElse(null);
        }, () -> null));
    }

    public static OAuthRegisteredService getRegisteredOAuthServiceByClientId(ServicesManager servicesManager, String clientId) {
        return OAuth20Utils.getRegisteredOAuthServiceByClientId(servicesManager, clientId, OAuthRegisteredService.class);
    }

    public static OAuthRegisteredService getRegisteredOAuthServiceByRedirectUri(ServicesManager servicesManager, String redirectUri) {
        OAuth20Utils.validateRedirectUri(redirectUri);
        return (OAuthRegisteredService)FunctionUtils.doIfNotBlank((CharSequence)redirectUri, () -> OAuth20Utils.getRegisteredOAuthServiceByPredicate(servicesManager, service -> service.matches(redirectUri)), () -> null);
    }

    private static OAuthRegisteredService getRegisteredOAuthServiceByPredicate(ServicesManager servicesManager, Predicate<OAuthRegisteredService> predicate) {
        Collection services = servicesManager.getAllServicesOfType(OAuthRegisteredService.class);
        return services.stream().filter(predicate).findFirst().orElse(null);
    }

    public static ModelAndView produceUnauthorizedErrorView() {
        return OAuth20Utils.produceUnauthorizedErrorView(HttpStatus.UNAUTHORIZED);
    }

    public static ModelAndView produceUnauthorizedErrorView(HttpStatus status) {
        RuntimeException ex = UnauthorizedServiceException.denied((String)"Rejected: %s".formatted(status));
        return OAuth20Utils.produceErrorView(ex, status);
    }

    public static ModelAndView produceErrorView(Exception e) {
        return OAuth20Utils.produceErrorView(e, HttpStatus.UNAUTHORIZED);
    }

    public static ModelAndView produceErrorView(Exception e, HttpStatus status) {
        ModelAndView mv = new ModelAndView("error/casServiceErrorView", CollectionUtils.wrap((String)"rootCauseException", (Object)e));
        mv.setStatus((HttpStatusCode)status);
        return mv;
    }

    public static String casOAuthCallbackUrl(String serverPrefixUrl) {
        return serverPrefixUrl.concat("/oauth2.0/callbackAuthorize");
    }

    public static String toJson(Object value) {
        return (String)FunctionUtils.doUnchecked(() -> MAPPER.writeValueAsString(value));
    }

    public static boolean isGrantType(String type, OAuth20GrantTypes expectedType) {
        return expectedType.getType().equalsIgnoreCase(type);
    }

    public static boolean isResponseType(String type, OAuth20ResponseTypes expectedType) {
        return expectedType.getType().equalsIgnoreCase(type);
    }

    public static boolean isResponseModeType(String type, OAuth20ResponseModeTypes expectedType) {
        return expectedType.getType().equalsIgnoreCase(type);
    }

    public static String getServiceRequestHeaderIfAny(WebContext context) {
        return context.getRequestHeader("service").or(() -> context.getRequestHeader("X-".concat("service"))).orElse("");
    }

    public static boolean checkCallbackValid(@NonNull RegisteredService registeredService, String redirectUri) {
        if (registeredService == null) {
            throw new NullPointerException("registeredService is marked non-null but is null");
        }
        RegisteredServiceMatchingStrategy matchingStrategy = Optional.of(registeredService).map(RegisteredService::getMatchingStrategy).orElse(null);
        OAuth20Utils.validateRedirectUri(redirectUri);
        if (matchingStrategy == null || !matchingStrategy.matches(registeredService, redirectUri)) {
            LOGGER.warn("Unsupported [{}]: [{}] does not match what is defined for registered service: [{}]. Service is considered unauthorized. Verify the service matching strategy used in the service definition is correct and does in fact match the client [{}]", new Object[]{"redirect_uri", redirectUri, registeredService.getServiceId(), redirectUri});
            return false;
        }
        return true;
    }

    public static boolean checkResponseTypes(String type, OAuth20ResponseTypes ... expectedTypes) {
        LOGGER.debug("Response type: [{}]", (Object)type);
        boolean checked = Stream.of(expectedTypes).anyMatch(t -> OAuth20Utils.isResponseType(type, t));
        if (!checked) {
            LOGGER.error("Unsupported response type: [{}]", (Object)type);
        }
        return checked;
    }

    public static String getClientIdFromAuthenticatedProfile(UserProfile profile) {
        HashMap attrs = new HashMap(profile.getAttributes());
        if (attrs.containsKey("client_id")) {
            Object attribute = attrs.get("client_id");
            return ((ArrayList)CollectionUtils.toCollection(attribute, ArrayList.class)).getFirst().toString();
        }
        return null;
    }

    public static Set<String> parseUserInfoRequestClaims(OAuth20Token token) {
        return token != null ? ((Map)token.getClaims().getOrDefault("userinfo", new HashMap())).keySet() : new HashSet<String>();
    }

    public static UserProfile getAuthenticatedUserProfile(WebContext context, SessionStore sessionStore) {
        ProfileManager manager = new ProfileManager(context, sessionStore);
        Optional profile = manager.getProfile();
        return (UserProfile)profile.orElseThrow(() -> new IllegalArgumentException("Unable to determine the user profile from the context"));
    }

    public static boolean doesServiceNeedAuthentication(OAuthRegisteredService registeredService) {
        return StringUtils.isNotBlank((CharSequence)registeredService.getClientSecret());
    }

    public static void validateRedirectUri(String redirectUri) {
        if (StringUtils.isNotBlank((CharSequence)redirectUri)) {
            RedirectURIValidator.ensureLegal((URI)URI.create(redirectUri));
        }
    }

    public static boolean isAccessTokenRequest(WebContext webContext) {
        return webContext.getRequestAttribute("oauth.request.access-token").orElse(false);
    }

    public static boolean isTokenAuthenticationMethodSupportedFor(CallContext callContext, OAuthRegisteredService registeredService, OAuth20ClientAuthenticationMethods ... authenticationMethod) {
        return !OAuth20Utils.isAccessTokenRequest(callContext.webContext()) || StringUtils.isBlank((CharSequence)registeredService.getTokenEndpointAuthenticationMethod()) || Arrays.stream(authenticationMethod).anyMatch(method -> Strings.CI.equals(registeredService.getTokenEndpointAuthenticationMethod(), method.getType()));
    }

    public static Boolean isStatelessAuthentication(ProfileManager manager) {
        return manager.getProfile().stream().map(OAuth20Utils::isStatelessAuthentication).findFirst().orElse(Boolean.FALSE);
    }

    public static Boolean isStatelessAuthentication(UserProfile profile) {
        Boolean validationResult = (Boolean)profile.getAttribute("org.apereo.cas.oauth.property.stateless");
        Object principal = profile.getAttribute(Principal.class.getName());
        return validationResult != null && validationResult != false && principal != null;
    }

    public static Long getAccessTokenTimeout(OAuth20TokenGeneratedResult accessTokenResult) {
        return accessTokenResult.getAccessToken().map(token -> {
            if (token.isStateless()) {
                Duration duration = Duration.between(ZonedDateTime.now(Clock.systemUTC()), token.getExpirationPolicy().toMaximumExpirationTime(token));
                return duration.toSeconds();
            }
            return ((OAuth20AccessToken)token).getExpiresIn();
        }).orElse(0L);
    }

    public static String extractClientIdFromToken(String token) throws Exception {
        JWTClaimsSet claims = JwtBuilder.parse((String)token);
        if (claims != null) {
            return claims.getClaimAsString("client_id");
        }
        Header header = JwtBuilder.parseHeader((String)token);
        return (String)header.getCustomParam("client_id");
    }

    @Generated
    private OAuth20Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

