/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.http.HttpMethod;

public abstract class BaseOAuth20TokenRequestValidator<T extends OAuth20ConfigurationContext>
implements OAuth20TokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOAuth20TokenRequestValidator.class);
    private final ObjectProvider<T> configurationContext;
    private int order = Integer.MAX_VALUE;

    private static boolean isGrantTypeSupported(String type, OAuth20GrantTypes ... expectedTypes) {
        LOGGER.debug("Grant type received: [{}]", (Object)type);
        for (OAuth20GrantTypes expectedType : expectedTypes) {
            if (!OAuth20Utils.isGrantType(type, expectedType)) continue;
            return true;
        }
        LOGGER.error("Unsupported grant type: [{}]", (Object)type);
        return false;
    }

    public boolean validate(WebContext context) throws Throwable {
        String grantType = ((OAuth20ConfigurationContext)this.configurationContext.getObject()).getRequestParameterResolver().resolveRequestParameter(context, "grant_type").orElse("");
        if (!BaseOAuth20TokenRequestValidator.isGrantTypeSupported(grantType, OAuth20GrantTypes.values())) {
            LOGGER.warn("Grant type is not supported: [{}]", (Object)grantType);
            return false;
        }
        ProfileManager manager = new ProfileManager(context, ((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getSessionStore());
        Optional profile = manager.getProfile();
        if (profile.isEmpty()) {
            LOGGER.warn("Could not locate authenticated profile for this request. Request is not authenticated");
            return false;
        }
        if (!this.validateClientSecretInRequestIfAny(context)) {
            LOGGER.warn("Cannot accept [{}] as a query parameter in the request", (Object)"client_secret");
            return false;
        }
        UserProfile userProfile = (UserProfile)profile.get();
        return this.validateInternal(context, grantType, manager, userProfile);
    }

    public boolean supports(WebContext context) {
        Optional grantType = ((OAuth20ConfigurationContext)this.configurationContext.getObject()).getRequestParameterResolver().resolveRequestParameter(context, "grant_type");
        return OAuth20Utils.isGrantType(grantType.map(String::valueOf).orElse(""), this.getGrantType());
    }

    protected boolean isGrantTypeSupportedBy(OAuthRegisteredService registeredService, String type) {
        return this.isGrantTypeSupportedBy(registeredService, type, false);
    }

    protected boolean isGrantTypeSupportedBy(OAuthRegisteredService registeredService, String type, boolean rejectUndefined) {
        return OAuth20RequestParameterResolver.isAuthorizedGrantTypeForService((String)type, (OAuthRegisteredService)registeredService, (boolean)rejectUndefined);
    }

    protected boolean validateInternal(WebContext context, String grantType, ProfileManager manager, UserProfile userProfile) throws Throwable {
        return false;
    }

    protected abstract OAuth20GrantTypes getGrantType();

    protected static Authentication resolveAuthenticationFrom(OAuth20Code oauthCode) {
        return oauthCode.isStateless() ? oauthCode.getAuthentication() : ((AuthenticationAwareTicket)oauthCode.getTicketGrantingTicket()).getAuthentication();
    }

    protected boolean validateClientSecretInRequestIfAny(WebContext webContext) {
        OAuth20RequestParameterResolver requestParameterResolver = ((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getRequestParameterResolver();
        HttpMethod httpMethod = HttpMethod.valueOf((String)webContext.getRequestMethod().toUpperCase(Locale.ROOT));
        return httpMethod.equals((Object)HttpMethod.POST) || !requestParameterResolver.isParameterOnQueryString(webContext, "client_secret");
    }

    @Generated
    protected BaseOAuth20TokenRequestValidator(ObjectProvider<T> configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public ObjectProvider<T> getConfigurationContext() {
        return this.configurationContext;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

