/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.NameUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public final class AttributeDeltaUtil {
    private AttributeDeltaUtil() {
    }

    public static String getStringValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : (String)obj;
    }

    public static Character getCharacterValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : (Character)obj;
    }

    public static GuardedByteArray getGuardedByteArrayValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : (GuardedByteArray)obj;
    }

    public static GuardedString getGuardedStringValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : (GuardedString)obj;
    }

    public static String getAsStringValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : obj.toString();
    }

    public static Byte getByteValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : (Byte)obj;
    }

    public static Byte[] getByteArrayValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        if (obj instanceof byte[]) {
            Byte[] copy = new Byte[((byte[])obj).length];
            for (int idx = 0; idx < ((byte[])obj).length; ++idx) {
                copy[idx] = ((byte[])obj)[idx];
            }
            return copy;
        }
        return obj == null ? null : (Byte[])obj;
    }

    public static Integer getIntegerValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : (Integer)obj;
    }

    public static Long getLongValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : (Long)obj;
    }

    public static Float getFloatValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : (Float)obj;
    }

    public static Date getDateValue(AttributeDelta attrDelta) {
        Long value = AttributeDeltaUtil.getLongValue(attrDelta);
        return value == null ? null : new Date(value);
    }

    public static Double getDoubleValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj != null ? (Double)obj : null;
    }

    public static BigDecimal getBigDecimalValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : (BigDecimal)obj;
    }

    public static BigInteger getBigIntegerValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : (BigInteger)obj;
    }

    public static Boolean getBooleanValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : (Boolean)obj;
    }

    public static Map<String, Object> getMapValue(AttributeDelta attrDelta) {
        Object obj = AttributeDeltaUtil.getSingleValue(attrDelta);
        return obj == null ? null : (Map)obj;
    }

    public static Object getSingleValue(AttributeDelta attr) {
        Object ret = null;
        List<Object> val = attr.getValuesToReplace();
        if (val != null && !val.isEmpty()) {
            if (val.size() > 1) {
                StringBuilder msg = new StringBuilder("The ").append(attr.getName()).append(" attributeDelta is not single value attribute.");
                throw new IllegalArgumentException(msg.toString());
            }
            ret = val.get(0);
        }
        return ret;
    }

    public static Map<String, AttributeDelta> toMap(Collection<? extends AttributeDelta> attributesDelta) {
        SortedMap ret = CollectionUtil.newCaseInsensitiveMap();
        for (AttributeDelta attributeDelta : attributesDelta) {
            ret.put(attributeDelta.getName(), attributeDelta);
        }
        return CollectionUtil.asReadOnlyMap(ret);
    }

    public static AttributeDelta getUidAttributeDelta(Set<AttributeDelta> attrsDelta) {
        return AttributeDeltaUtil.find(Uid.NAME, attrsDelta);
    }

    public static Attribute getEmptyAttribute(AttributeDelta attrDelta) {
        return AttributeBuilder.build(attrDelta.getName());
    }

    public static Set<AttributeDelta> getBasicAttributes(Set<AttributeDelta> attrsDelta) {
        HashSet<AttributeDelta> ret = new HashSet<AttributeDelta>();
        for (AttributeDelta attrDelta : attrsDelta) {
            if (AttributeDeltaUtil.isSpecial(attrDelta)) continue;
            ret.add(attrDelta);
        }
        return ret;
    }

    public static Set<AttributeDelta> getSpecialAttributes(Set<AttributeDelta> attrsDelta) {
        HashSet<AttributeDelta> ret = new HashSet<AttributeDelta>();
        for (AttributeDelta attr : attrsDelta) {
            if (!AttributeDeltaUtil.isSpecial(attr)) continue;
            ret.add(attr);
        }
        return ret;
    }

    public static Set<AttributeDelta> filterUid(Set<AttributeDelta> attrsDelta) {
        Assertions.nullCheck(attrsDelta, "attrsDelta");
        HashSet<AttributeDelta> ret = new HashSet<AttributeDelta>();
        for (AttributeDelta attrDelta : attrsDelta) {
            if (attrDelta.is(Uid.NAME)) continue;
            ret.add(attrDelta);
        }
        return ret;
    }

    public static Set<AttributeDelta> addUid(Set<AttributeDelta> attrsDelta, Object ... values) {
        Assertions.nullCheck(attrsDelta, "attrs");
        Assertions.nullCheck(values, "uid's values");
        HashSet<AttributeDelta> ret = new HashSet<AttributeDelta>(attrsDelta);
        ret.add(AttributeDeltaBuilder.build(Uid.NAME, values));
        return ret;
    }

    public static boolean isSpecial(AttributeDelta attrDelta) {
        String name = attrDelta.getName();
        return AttributeDeltaUtil.isSpecialName(name);
    }

    public static boolean isSpecialName(String name) {
        return NameUtil.isSpecialName(name);
    }

    public static boolean namesEqual(String name1, String name2) {
        return NameUtil.namesEqual(name1, name2);
    }

    public static AttributeDelta getAttributeDeltaForName(Set<AttributeDelta> attrsDelta) {
        return AttributeDeltaUtil.find(Name.NAME, attrsDelta);
    }

    public static AttributeDelta find(String name, Set<AttributeDelta> attrsDelta) {
        Assertions.nullCheck(name, "name");
        Set<AttributeDelta> set = CollectionUtil.nullAsEmpty(attrsDelta);
        for (AttributeDelta attrDelta : set) {
            if (!attrDelta.is(name)) continue;
            return attrDelta;
        }
        return null;
    }

    public static GuardedString getPasswordValue(Set<AttributeDelta> attrsDelta) {
        AttributeDelta pwd = AttributeDeltaUtil.find(OperationalAttributes.PASSWORD_NAME, attrsDelta);
        return pwd == null ? null : AttributeDeltaUtil.getGuardedStringValue(pwd);
    }

    public static GuardedString getCurrentPasswordValue(Set<AttributeDelta> attrsDelta) {
        AttributeDelta pwd = AttributeDeltaUtil.find(OperationalAttributes.CURRENT_PASSWORD_NAME, attrsDelta);
        return pwd == null ? null : AttributeDeltaUtil.getGuardedStringValue(pwd);
    }

    public static Boolean getPasswordExpired(Set<AttributeDelta> attrsDelta) {
        AttributeDelta pwd = AttributeDeltaUtil.find(OperationalAttributes.PASSWORD_EXPIRED_NAME, attrsDelta);
        return pwd == null ? null : AttributeDeltaUtil.getBooleanValue(pwd);
    }

    public static Date getEnableDate(Set<AttributeDelta> attrsDelta) {
        AttributeDelta date = AttributeDeltaUtil.find(OperationalAttributes.ENABLE_DATE_NAME, attrsDelta);
        return date == null ? null : AttributeDeltaUtil.getDateValue(date);
    }
}

