/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap.mapping;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.AbstractJDBCConf;
import org.apache.syncope.common.lib.AbstractLDAPConf;
import org.apache.syncope.common.lib.password.JDBCPasswordManagementConf;
import org.apache.syncope.common.lib.password.LDAPPasswordManagementConf;
import org.apache.syncope.common.lib.password.PasswordManagementConf;
import org.apache.syncope.common.lib.password.RESTPasswordManagementConf;
import org.apache.syncope.common.lib.password.SyncopePasswordManagementConf;
import org.apache.syncope.common.lib.to.PasswordManagementTO;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.bootstrap.mapping.PropertySourceMapper;
import org.apache.syncope.wa.bootstrap.mapping.WAConfUtils;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapSearchProperties;
import org.apereo.cas.configuration.model.support.pm.JdbcPasswordManagementProperties;
import org.apereo.cas.configuration.model.support.pm.LdapPasswordManagementProperties;
import org.apereo.cas.configuration.model.support.pm.RestfulPasswordManagementProperties;
import org.apereo.cas.configuration.model.support.pm.SyncopePasswordManagementProperties;

public class PasswordManagementPropertySourceMapper
extends PropertySourceMapper
implements PasswordManagementConf.Mapper {
    protected final WARestClient waRestClient;

    public PasswordManagementPropertySourceMapper(WARestClient waRestClient) {
        this.waRestClient = waRestClient;
    }

    public Map<String, Object> map(PasswordManagementTO passwordManagementTO, SyncopePasswordManagementConf conf) {
        SyncopeClient syncopeClient = this.waRestClient.getSyncopeClient();
        if (syncopeClient == null) {
            LOG.warn("Application context is not ready to bootstrap WA configuration");
            return Map.of();
        }
        SyncopePasswordManagementProperties props = new SyncopePasswordManagementProperties();
        props.setDomain(conf.getDomain());
        props.setUrl(StringUtils.substringBefore((String)syncopeClient.getAddress(), (String)"/rest"));
        props.setBasicAuthUsername(conf.getBasicAuthUsername());
        props.setBasicAuthPassword(conf.getBasicAuthPassword());
        props.setSearchFilter(conf.getSearchFilter());
        props.setHeaders(conf.getHeaders());
        Map<String, Object> mapped = PasswordManagementPropertySourceMapper.prefix("cas.authn.pm.syncope.", WAConfUtils.asMap((Serializable)props));
        mapped.put("cas.authn.pm.syncope.enabled", passwordManagementTO.isEnabled());
        return mapped;
    }

    public Map<String, Object> map(PasswordManagementTO passwordManagementTO, LDAPPasswordManagementConf conf) {
        LdapPasswordManagementProperties props = new LdapPasswordManagementProperties();
        props.setName(passwordManagementTO.getKey());
        props.setType(AbstractLdapProperties.LdapType.valueOf((String)conf.getLdapType().name()));
        props.setUsernameAttribute(conf.getUsernameAttribute());
        this.fill((AbstractLdapSearchProperties)props, (AbstractLDAPConf)conf);
        Map<String, Object> mapped = PasswordManagementPropertySourceMapper.prefix("cas.authn.pm.ldap[].", WAConfUtils.asMap((Serializable)props));
        mapped.put("cas.authn.pm.ldap.enabled", passwordManagementTO.isEnabled());
        return mapped;
    }

    public Map<String, Object> map(PasswordManagementTO passwordManagementTO, JDBCPasswordManagementConf conf) {
        JdbcPasswordManagementProperties props = new JdbcPasswordManagementProperties();
        props.setSqlChangePassword(conf.getSqlChangePassword());
        props.setSqlFindEmail(conf.getSqlFindEmail());
        props.setSqlFindPhone(conf.getSqlFindPhone());
        props.setSqlFindUser(conf.getSqlFindUser());
        props.setSqlGetSecurityQuestions(conf.getSqlGetSecurityQuestions());
        props.setSqlUpdateSecurityQuestions(conf.getSqlUpdateSecurityQuestions());
        props.setSqlDeleteSecurityQuestions(conf.getSqlDeleteSecurityQuestions());
        props.setSqlUnlockAccount(conf.getSqlUnlockAccount());
        this.fill((AbstractJpaProperties)props, (AbstractJDBCConf)conf);
        Map<String, Object> mapped = PasswordManagementPropertySourceMapper.prefix("cas.authn.pm.jdbc.", WAConfUtils.asMap((Serializable)props));
        mapped.put("cas.authn.pm.jdbc.enabled", passwordManagementTO.isEnabled());
        return mapped;
    }

    public Map<String, Object> map(PasswordManagementTO passwordManagementTO, RESTPasswordManagementConf conf) {
        RestfulPasswordManagementProperties props = new RestfulPasswordManagementProperties();
        props.setEndpointPassword(conf.getEndpointPassword());
        props.setEndpointUrlAccountUnlock(conf.getEndpointUrlAccountUnlock());
        props.setEndpointUrlChange(conf.getEndpointUrlChange());
        props.setEndpointUrlEmail(conf.getEndpointUrlEmail());
        props.setEndpointUrlPhone(conf.getEndpointUrlPhone());
        props.setEndpointUrlSecurityQuestions(conf.getEndpointUrlSecurityQuestions());
        props.setEndpointUrlUser(conf.getEndpointUrlUser());
        props.setEndpointUsername(conf.getEndpointUsername());
        props.setFieldNamePasswordOld(conf.getFieldNamePasswordOld());
        props.setFieldNamePassword(conf.getFieldNamePassword());
        props.setFieldNameUser(conf.getFieldNameUser());
        props.setHeaders(conf.getHeaders());
        Map<String, Object> mapped = PasswordManagementPropertySourceMapper.prefix("cas.authn.pm.rest.", WAConfUtils.asMap((Serializable)props));
        mapped.put("cas.authn.pm.rest.enabled", passwordManagementTO.isEnabled());
        return mapped;
    }
}

