/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.xml.ParserPool;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.util.credential.BasicResourceCredentialFactoryBean;
import org.apereo.cas.support.saml.util.credential.BasicX509CredentialFactoryBean;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.cryptacular.util.CertUtil;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.soap.common.SOAPObject;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.criterion.SignatureValidationConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureValidationParametersResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.DEREncodedKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.SignatureValidationParametersCriterion;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SamlUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlUtils.class);
    private static final ThreadLocal<TransformerFactory> TRANSFORMER_FACTORY_INSTANCE = ThreadLocal.withInitial(TransformerFactory::newInstance);
    private static final String DEFAULT_ELEMENT_NAME_FIELD = "DEFAULT_ELEMENT_NAME";
    private static final int SAML_OBJECT_LOG_ASTERIXLINE_LENGTH = 80;

    public static QName getSamlObjectQName(Class objectType) {
        try {
            Field f = objectType.getField(DEFAULT_ELEMENT_NAME_FIELD);
            return (QName)f.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot find/access field " + objectType.getName() + ".DEFAULT_ELEMENT_NAME", e);
        }
    }

    public static <T extends SOAPObject> T newSoapObject(Class<T> objectType) {
        QName qName = SamlUtils.getSamlObjectQName(objectType);
        LOGGER.trace("Attempting to create SOAPObject for type: [{}] and QName: [{}]", objectType, (Object)qName);
        SOAPObjectBuilder builder = (SOAPObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(qName);
        return (T)((SOAPObject)objectType.cast(Objects.requireNonNull(builder).buildObject(qName)));
    }

    public static <T extends SAMLObject> T newSamlObject(Class<T> objectType) {
        QName qName = SamlUtils.getSamlObjectQName(objectType);
        return SamlUtils.newSamlObject(objectType, qName);
    }

    public static <T extends SAMLObject> T newSamlObject(Class<T> objectType, QName qName) {
        LOGGER.trace("Attempting to create SAMLObject for type: [{}] and QName: [{}]", objectType, (Object)qName);
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(qName);
        return (T)((SAMLObject)objectType.cast(Objects.requireNonNull(builder).buildObject(qName)));
    }

    public static Element getRootElementFrom(InputStream metadataResource, OpenSamlConfigBean configBean) {
        return (Element)FunctionUtils.doUnchecked(() -> {
            try (InputStream inputStream = metadataResource;){
                Document document = configBean.getParserPool().parse(metadataResource);
                Element element = document.getDocumentElement();
                return element;
            }
        });
    }

    public static X509Certificate readCertificate(Resource resource) {
        X509Certificate x509Certificate;
        block8: {
            InputStream in = resource.getInputStream();
            try {
                x509Certificate = CertUtil.readCertificate((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error reading certificate " + String.valueOf(resource), e);
                }
            }
            in.close();
        }
        return x509Certificate;
    }

    public static StringWriter transformSamlObject(OpenSamlConfigBean configBean, XMLObject samlObject) throws SamlException {
        return SamlUtils.transformSamlObject(configBean, samlObject, false);
    }

    public static <T extends XMLObject> T transformSamlObject(OpenSamlConfigBean configBean, String xml, Class<T> clazz) {
        return SamlUtils.transformSamlObject(configBean, xml.getBytes(StandardCharsets.UTF_8), clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends XMLObject> T transformSamlObject(OpenSamlConfigBean configBean, byte[] data, Class<T> clazz) {
        if (data == null) return null;
        if (data.length <= 0) return null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            Document document = configBean.getParserPool().parse((InputStream)in);
            Element root = document.getDocumentElement();
            Unmarshaller marshaller = configBean.getUnmarshallerFactory().getUnmarshaller(root);
            if (marshaller == null) return null;
            XMLObject result = marshaller.unmarshall(root);
            if (!clazz.isAssignableFrom(result.getClass())) {
                throw new ClassCastException("Result [" + String.valueOf(result) + " is of type " + String.valueOf(result.getClass()) + " when we were expecting " + String.valueOf(clazz));
            }
            XMLObject xMLObject = result;
            return (T)xMLObject;
        }
        catch (Exception e) {
            throw new SamlException(e.getMessage(), e);
        }
    }

    public static StringWriter transformSamlObject(OpenSamlConfigBean configBean, XMLObject samlObject, boolean indent) throws SamlException {
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = configBean.getMarshallerFactory().getMarshaller(samlObject.getElementQName());
            if (marshaller != null) {
                Element element = marshaller.marshall(samlObject);
                DOMSource domSource = new DOMSource(element);
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TRANSFORMER_FACTORY_INSTANCE.get();
                tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Transformer transformer = tf.newTransformer();
                if (indent) {
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                }
                transformer.transform(domSource, result);
            }
        }
        catch (Exception e) {
            throw new SamlException(e.getMessage(), e);
        }
        return writer;
    }

    public static SignatureValidationFilter buildSignatureValidationFilter(String signatureResourceLocation) throws Exception {
        AbstractResource resource = ResourceUtils.getResourceFrom((String)signatureResourceLocation);
        return SamlUtils.buildSignatureValidationFilter((Resource)resource);
    }

    public static SignatureValidationFilter buildSignatureValidationFilter(ResourceLoader resourceLoader, String signatureResourceLocation) {
        try {
            Resource resource = resourceLoader.getResource(signatureResourceLocation);
            return SamlUtils.buildSignatureValidationFilter(resource);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static SignatureValidationFilter buildSignatureValidationFilter(Resource signatureResourceLocation) throws Exception {
        if (!ResourceUtils.doesResourceExist((Resource)signatureResourceLocation)) {
            LOGGER.warn("Resource [{}] cannot be located", (Object)signatureResourceLocation);
            return null;
        }
        ArrayList<Object> keyInfoProviderList = new ArrayList<Object>(4);
        keyInfoProviderList.add(new RSAKeyValueProvider());
        keyInfoProviderList.add(new DSAKeyValueProvider());
        keyInfoProviderList.add(new DEREncodedKeyValueProvider());
        keyInfoProviderList.add(new InlineX509DataProvider());
        LOGGER.debug("Attempting to resolve credentials from [{}]", (Object)signatureResourceLocation);
        BasicCredential credential = SamlUtils.buildCredentialForMetadataSignatureValidation(signatureResourceLocation);
        LOGGER.info("Successfully resolved credentials from [{}]", (Object)signatureResourceLocation);
        LOGGER.debug("Configuring credential resolver for key signature trust engine @ [{}]", (Object)credential.getCredentialType().getSimpleName());
        StaticCredentialResolver resolver = new StaticCredentialResolver((Credential)credential);
        BasicProviderKeyInfoCredentialResolver keyInfoResolver = new BasicProviderKeyInfoCredentialResolver(keyInfoProviderList);
        ExplicitKeySignatureTrustEngine trustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)resolver, (KeyInfoCredentialResolver)keyInfoResolver);
        LOGGER.debug("Adding signature validation filter based on the configured trust engine");
        SignatureValidationFilter signatureValidationFilter = new SignatureValidationFilter((SignatureTrustEngine)trustEngine);
        signatureValidationFilter.setDefaultCriteria(SamlUtils.buildSignatureValidationFilterCriteria());
        LOGGER.debug("Added metadata SignatureValidationFilter with signature from [{}]", (Object)signatureResourceLocation);
        return signatureValidationFilter;
    }

    public static void logSamlObject(OpenSamlConfigBean configBean, XMLObject samlObject) throws SamlException {
        if (LOGGER.isDebugEnabled() || LoggingUtils.isProtocolMessageLoggerEnabled()) {
            String repeat = "*".repeat(80);
            LOGGER.debug(repeat);
            try (StringWriter writer = SamlUtils.transformSamlObject(configBean, samlObject, true);){
                LOGGER.debug("Logging [{}]\n\n[{}]\n\n", (Object)samlObject.getClass().getName(), (Object)writer);
                LOGGER.debug(repeat);
                LoggingUtils.protocolMessage((String)("SAML " + samlObject.getClass().getName()), Map.of(), (Object)writer.toString());
            }
            catch (Exception e) {
                throw new SamlException(e.getMessage(), e);
            }
        }
    }

    public static boolean isDynamicMetadataQueryConfigured(String metadataLocation) {
        return StringUtils.isNotBlank((CharSequence)metadataLocation) && metadataLocation.trim().endsWith("/entities/{0}");
    }

    private static BasicCredential buildCredentialForMetadataSignatureValidation(Resource resource) throws Exception {
        try {
            BasicX509CredentialFactoryBean x509FactoryBean = new BasicX509CredentialFactoryBean();
            x509FactoryBean.setCertificateResources(CollectionUtils.wrap((Object)resource));
            return x509FactoryBean.getObject();
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            LOGGER.debug("Credential cannot be extracted from [{}] via X.509. Treating it as a public key to locate credential...", (Object)resource);
            BasicResourceCredentialFactoryBean credentialFactoryBean = new BasicResourceCredentialFactoryBean();
            credentialFactoryBean.setPublicKeyInfo(resource);
            return credentialFactoryBean.getObject();
        }
    }

    private static CriteriaSet buildSignatureValidationFilterCriteria() {
        CriteriaSet criteriaSet = new CriteriaSet();
        ArrayList<SignatureValidationConfiguration> sigConfigs = new ArrayList<SignatureValidationConfiguration>();
        sigConfigs.add(SecurityConfigurationSupport.getGlobalSignatureValidationConfiguration());
        if (!sigConfigs.isEmpty()) {
            BasicSignatureValidationParametersResolver paramsResolver = new BasicSignatureValidationParametersResolver();
            CriteriaSet configCriteria = new CriteriaSet(new Criterion[]{new SignatureValidationConfigurationCriterion(sigConfigs)});
            SignatureValidationParameters params = (SignatureValidationParameters)FunctionUtils.doUnchecked(() -> paramsResolver.resolveSingle(configCriteria));
            if (params != null) {
                criteriaSet.add((Object)new SignatureValidationParametersCriterion(params), true);
            }
        }
        return criteriaSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends RequestAbstractType> T convertToSamlObject(OpenSamlConfigBean openSamlConfigBean, String requestValue, Class<T> clazz) {
        try {
            LOGGER.trace("Retrieving SAML request from [{}]", (Object)requestValue);
            byte[] decodedBytes = Base64Support.decode((String)requestValue);
            try (InflaterInputStream is = new InflaterInputStream(new ByteArrayInputStream(decodedBytes), new Inflater(true));){
                RequestAbstractType requestAbstractType = (RequestAbstractType)clazz.cast(XMLObjectSupport.unmarshallFromInputStream((ParserPool)openSamlConfigBean.getParserPool(), (InputStream)is));
                return (T)requestAbstractType;
            }
        }
        catch (Throwable e) {
            return (T)((RequestAbstractType)FunctionUtils.doUnchecked(() -> {
                byte[] encodedRequest = EncodingUtils.decodeBase64((byte[])requestValue.getBytes(StandardCharsets.UTF_8));
                try (ByteArrayInputStream is = new ByteArrayInputStream(encodedRequest);){
                    RequestAbstractType requestAbstractType = (RequestAbstractType)clazz.cast(XMLObjectSupport.unmarshallFromInputStream((ParserPool)openSamlConfigBean.getParserPool(), (InputStream)is));
                    return requestAbstractType;
                }
            }));
        }
    }

    @Generated
    private SamlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

