/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.authentication.principal.SamlService;
import org.apereo.cas.support.saml.util.AbstractSamlObjectBuilder;
import org.apereo.cas.support.saml.util.CasHttpSoap11Encoder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.AttributeValue;
import org.opensaml.saml.saml1.core.Audience;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.ConfirmationMethod;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Status;
import org.opensaml.saml.saml1.core.StatusCode;
import org.opensaml.saml.saml1.core.StatusMessage;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.core.SubjectConfirmation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Saml10ObjectBuilder
extends AbstractSamlObjectBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Saml10ObjectBuilder.class);
    private static final String CONFIRMATION_METHOD = "urn:oasis:names:tc:SAML:1.0:cm:artifact";

    public Saml10ObjectBuilder(OpenSamlConfigBean configBean) {
        super(configBean);
    }

    private static void setInResponseToForSamlResponseIfNeeded(Service service, Response samlResponse) {
        SamlService samlService;
        String requestId;
        if (service instanceof SamlService && StringUtils.isNotBlank((CharSequence)(requestId = (samlService = (SamlService)service).getRequestId()))) {
            samlResponse.setInResponseTo(requestId);
        }
    }

    public Response newResponse(String id, ZonedDateTime issueInstant, String recipient, WebApplicationService service) {
        Response samlResponse = SamlUtils.newSamlObject(Response.class);
        samlResponse.setID(id);
        samlResponse.setIssueInstant(issueInstant.toInstant());
        samlResponse.setVersion(SAMLVersion.VERSION_11);
        samlResponse.setInResponseTo(recipient);
        Saml10ObjectBuilder.setInResponseToForSamlResponseIfNeeded((Service)service, samlResponse);
        return samlResponse;
    }

    public Assertion newAssertion(AuthenticationStatement authnStatement, String issuer, ZonedDateTime issuedAt, String id) {
        Assertion assertion = SamlUtils.newSamlObject(Assertion.class);
        assertion.setID(id);
        assertion.setIssueInstant(issuedAt.toInstant());
        assertion.setIssuer(issuer);
        assertion.getAuthenticationStatements().add(authnStatement);
        return assertion;
    }

    public Conditions newConditions(ZonedDateTime issuedAt, String audienceUri, long issueLength) {
        Conditions conditions = SamlUtils.newSamlObject(Conditions.class);
        conditions.setNotBefore(issuedAt.toInstant());
        ZonedDateTime notOnOrAfter = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(issueLength);
        conditions.setNotOnOrAfter(notOnOrAfter.toInstant());
        AudienceRestrictionCondition audienceRestriction = SamlUtils.newSamlObject(AudienceRestrictionCondition.class);
        Audience audience = SamlUtils.newSamlObject(Audience.class);
        audience.setURI(audienceUri);
        audienceRestriction.getAudiences().add(audience);
        conditions.getAudienceRestrictionConditions().add(audienceRestriction);
        return conditions;
    }

    public Status newStatus(QName codeValue) {
        return this.newStatus(codeValue, "");
    }

    public Status newStatus(QName codeValue, String statusMessage) {
        Status status = SamlUtils.newSamlObject(Status.class);
        StatusCode code = SamlUtils.newSamlObject(StatusCode.class);
        code.setValue(codeValue);
        status.setStatusCode(code);
        if (StringUtils.isNotBlank((CharSequence)statusMessage)) {
            StatusMessage message = SamlUtils.newSamlObject(StatusMessage.class);
            message.setValue(statusMessage);
            status.setStatusMessage(message);
        }
        return status;
    }

    public AuthenticationStatement newAuthenticationStatement(ZonedDateTime authenticationDate, Collection<Object> authenticationMethod, String subjectId) {
        AuthenticationStatement authnStatement = SamlUtils.newSamlObject(AuthenticationStatement.class);
        authnStatement.setAuthenticationInstant(authenticationDate.toInstant());
        authnStatement.setAuthenticationMethod(authenticationMethod != null && !authenticationMethod.isEmpty() ? authenticationMethod.iterator().next().toString() : "urn:oasis:names:tc:SAML:1.0:am:unspecified");
        authnStatement.setSubject(this.newSubject(subjectId));
        return authnStatement;
    }

    public Subject newSubject(String identifier) {
        return this.newSubject(identifier, CONFIRMATION_METHOD);
    }

    public Subject newSubject(String identifier, String confirmationMethod) {
        SubjectConfirmation confirmation = SamlUtils.newSamlObject(SubjectConfirmation.class);
        ConfirmationMethod method = SamlUtils.newSamlObject(ConfirmationMethod.class);
        method.setURI(confirmationMethod);
        confirmation.getConfirmationMethods().add(method);
        NameIdentifier nameIdentifier = SamlUtils.newSamlObject(NameIdentifier.class);
        nameIdentifier.setValue(identifier);
        Subject subject = SamlUtils.newSamlObject(Subject.class);
        subject.setNameIdentifier(nameIdentifier);
        subject.setSubjectConfirmation(confirmation);
        return subject;
    }

    public void addAttributeValuesToSaml1Attribute(String attributeName, Object attributeValue, List<XMLObject> attributeList) {
        this.addAttributeValuesToSamlAttribute(attributeName, attributeValue, "", attributeList, AttributeValue.DEFAULT_ELEMENT_NAME);
    }

    public AttributeStatement newAttributeStatement(Subject subject, Map<String, Object> attributes, String attributeNamespace) {
        AttributeStatement attrStatement = SamlUtils.newSamlObject(AttributeStatement.class);
        attrStatement.setSubject(subject);
        for (Map.Entry<String, Object> e : attributes.entrySet()) {
            if (e.getValue() instanceof Collection && ((Collection)e.getValue()).isEmpty()) {
                LOGGER.info("Skipping attribute [{}] because it does not have any values.", (Object)e.getKey());
                continue;
            }
            Attribute attribute = SamlUtils.newSamlObject(Attribute.class);
            attribute.setAttributeName(e.getKey());
            if (StringUtils.isNotBlank((CharSequence)attributeNamespace)) {
                attribute.setAttributeNamespace(attributeNamespace);
            }
            this.addAttributeValuesToSaml1Attribute(e.getKey(), e.getValue(), attribute.getAttributeValues());
            attrStatement.getAttributes().add(attribute);
        }
        return attrStatement;
    }

    public void encodeSamlResponse(HttpServletResponse httpResponse, HttpServletRequest httpRequest, Response samlMessage) throws Exception {
        this.openSamlConfigBean.logObject((XMLObject)samlMessage);
        CasHttpSoap11Encoder encoder = new CasHttpSoap11Encoder();
        MessageContext context = new MessageContext();
        context.setMessage((Object)samlMessage);
        encoder.setHttpServletResponseSupplier(() -> httpResponse);
        encoder.setMessageContext(context);
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
    }
}

