/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.saml2;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.replication.CookieSessionReplicationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.idp.slo.SamlIdPProfileSingleLogoutRequestProcessor;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.WebUtils;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationSamlIdPSingleLogoutRequestProcessor
implements SamlIdPProfileSingleLogoutRequestProcessor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationSamlIdPSingleLogoutRequestProcessor.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).minimal(true).build().toObjectMapper();
    @Deprecated(since="7.3.0", forRemoval=true)
    private final CasCookieBuilder delegatedSaml2IdPSloRequestCookieGenerator;
    private final ServiceFactory serviceFactory;
    private final ServicesManager servicesManager;
    private final CasConfigurationProperties casProperties;

    public void receive(HttpServletRequest request, HttpServletResponse response, LogoutRequest logoutRequest, MessageContext messageContext) throws Exception {
        this.autoConfigureCookieIfNecessary(request);
        this.createSamlLogoutRequestCookie(request, response, logoutRequest, messageContext);
    }

    public void restore(RequestContext requestContext) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        RegisteredService registeredService = WebUtils.getRegisteredService((HttpServletRequest)request);
        String cookieValue = this.delegatedSaml2IdPSloRequestCookieGenerator.retrieveCookieValue(request);
        if (registeredService == null && StringUtils.isNotBlank((CharSequence)cookieValue)) {
            byte[] decodedCookieValue = EncodingUtils.decodeBase64((String)cookieValue);
            Map cookieValues = (Map)MAPPER.readValue(decodedCookieValue, Map.class);
            String samlLogoutRequest = (String)cookieValues.get("SAMLRequest");
            String entityId = (String)cookieValues.get("entityId");
            String relayState = (String)cookieValues.get("RelayState");
            Service service = this.serviceFactory.createService(entityId);
            service.getAttributes().put("entityId", entityId);
            service.getAttributes().put("SAMLRequest", samlLogoutRequest);
            registeredService = this.servicesManager.findServiceBy(service);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
            WebUtils.putRegisteredService((HttpServletRequest)request, (RegisteredService)registeredService);
            WebUtils.putSingleLogoutRequest((HttpServletRequest)request, (String)samlLogoutRequest);
            request.setAttribute("RelayState", (Object)relayState);
            requestContext.getFlowScope().put("RelayState", (Object)relayState);
            this.delegatedSaml2IdPSloRequestCookieGenerator.removeCookie(response);
        }
    }

    protected void createSamlLogoutRequestCookie(HttpServletRequest request, HttpServletResponse response, LogoutRequest logoutRequest, MessageContext messageContext) throws Exception {
        String relayState = StringUtils.defaultString((String)SAMLBindingSupport.getRelayState((MessageContext)messageContext));
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)logoutRequest);
        String sloRequest = StringUtils.defaultString((String)WebUtils.getSingleLogoutRequest((HttpServletRequest)request));
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("entityId", issuer);
        FunctionUtils.doIfNotBlank((CharSequence)relayState, value -> payload.put("RelayState", (String)value));
        FunctionUtils.doIfNotBlank((CharSequence)relayState, value -> payload.put("SAMLRequest", sloRequest));
        String cookieValue = EncodingUtils.encodeBase64((byte[])MAPPER.writeValueAsString(payload).getBytes(StandardCharsets.UTF_8));
        this.delegatedSaml2IdPSloRequestCookieGenerator.addCookie(request, response, cookieValue);
    }

    @Deprecated(since="7.3.0", forRemoval=true)
    protected void autoConfigureCookieIfNecessary(HttpServletRequest request) {
        CookieSessionReplicationProperties cookieProps = this.casProperties.getAuthn().getPac4j().getCore().getSessionReplication().getCookie();
        if (cookieProps.isAutoConfigureCookiePath()) {
            CookieUtils.configureCookiePath((HttpServletRequest)request, (CasCookieBuilder)this.delegatedSaml2IdPSloRequestCookieGenerator);
        }
    }

    @Generated
    public DelegatedAuthenticationSamlIdPSingleLogoutRequestProcessor(CasCookieBuilder delegatedSaml2IdPSloRequestCookieGenerator, ServiceFactory serviceFactory, ServicesManager servicesManager, CasConfigurationProperties casProperties) {
        this.delegatedSaml2IdPSloRequestCookieGenerator = delegatedSaml2IdPSloRequestCookieGenerator;
        this.serviceFactory = serviceFactory;
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
    }
}

