/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.jpa.dao.OracleJPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.repo.OraclePlainSchemaRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.PlainSchemaRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.OracleEntityFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="persistence", name={"db-type"}, havingValue="ORACLE")
public class OraclePersistenceContext {
    @ConditionalOnMissingBean
    @Bean
    public EntityFactory entityFactory() {
        return new OracleEntityFactory();
    }

    @ConditionalOnMissingBean
    @Bean
    public AnySearchDAO anySearchDAO(@Lazy RealmSearchDAO realmSearchDAO, @Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, @Lazy PlainSchemaDAO schemaDAO, @Lazy EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityManagerFactory entityManagerFactory, EntityManager entityManager) {
        return new OracleJPAAnySearchDAO(realmSearchDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator, entityManagerFactory, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public PlainSchemaRepoExt plainSchemaRepoExt(AnyUtilsFactory anyUtilsFactory, @Lazy ExternalResourceDAO resourceDAO, @Lazy PlainSchemaDAO plainSchemaDAO, EntityManager entityManager) {
        return new OraclePlainSchemaRepoExtImpl(anyUtilsFactory, resourceDAO, plainSchemaDAO, entityManager);
    }
}

