/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.common.dao.AbstractAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.AbstractJPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.AnySearchNode;
import org.apache.syncope.core.persistence.jpa.dao.OrderBySupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.springframework.data.domain.Sort;

public class PGJPAAnySearchDAO
extends AbstractJPAAnySearchDAO {
    protected static final String REGEX_CHARS = "!$()*+.:<=>?[\\]^{|}-";

    protected static String escapeForLikeRegex(String input) {
        String output = input;
        for (char toEscape : REGEX_CHARS.toCharArray()) {
            output = output.replace(String.valueOf(toEscape), "\\" + toEscape);
        }
        return output.replace("'", "''");
    }

    protected static String escapeIfString(String value, boolean isStr) {
        return isStr ? '\"' + value.replace("'", "''") + '\"' : value;
    }

    public PGJPAAnySearchDAO(RealmSearchDAO realmSearchDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityManagerFactory entityManagerFactory, EntityManager entityManager) {
        super(realmSearchDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator, entityManagerFactory, entityManager);
    }

    @Override
    protected SearchSupport.SearchView defaultSV(SearchSupport svs) {
        return svs.table();
    }

    @Override
    protected String anyId(SearchSupport.SearchView sv) {
        return sv.alias() + ".id";
    }

    @Override
    protected void parseOrderByForPlainSchema(SearchSupport svs, OrderBySupport obs, OrderBySupport.Item item, Sort.Order clause, PlainSchema schema, String fieldName) {
        obs.nonMandatorySchemas = !"true".equals(schema.getMandatoryCondition());
        obs.views.add(svs.table());
        item.select = fieldName + " -> 0 AS " + fieldName;
        item.where = "";
        item.orderBy = fieldName + " " + clause.getDirection().name();
    }

    @Override
    protected void parseOrderByForField(SearchSupport svs, OrderBySupport.Item item, String fieldName, Sort.Order clause) {
        item.select = svs.table().alias() + "." + fieldName;
        item.where = "";
        item.orderBy = svs.table().alias() + "." + fieldName + " " + clause.getDirection().name();
    }

    protected AnySearchNode.Leaf filJSONAttrQuery(SearchSupport.SearchView from, PlainAttrValue attrValue, PlainSchema schema, AttrCond cond, boolean not) {
        String key = PGJPAAnySearchDAO.key((AttrSchemaType)schema.getType());
        String value = Optional.ofNullable(attrValue.getDateValue()).map(DateTimeFormatter.ISO_OFFSET_DATE_TIME::format).orElseGet(() -> ((AttrCond)cond).getExpression());
        boolean isStr = true;
        boolean lower = false;
        if (schema.getType() == AttrSchemaType.String || schema.getType() == AttrSchemaType.Enum) {
            lower = cond.getType() == AttrCond.Type.IEQ || cond.getType() == AttrCond.Type.ILIKE;
        } else if (schema.getType() != AttrSchemaType.Date) {
            lower = false;
            try {
                switch (schema.getType()) {
                    case Long: {
                        Long.valueOf(value);
                        break;
                    }
                    case Double: {
                        Double.valueOf(value);
                        break;
                    }
                    case Boolean: {
                        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) break;
                        throw new IllegalArgumentException();
                    }
                }
                isStr = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StringBuilder clause = new StringBuilder();
        switch (cond.getType()) {
            case ILIKE: 
            case LIKE: {
                if (schema.getType() == AttrSchemaType.String || schema.getType() == AttrSchemaType.Enum) {
                    clause.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*] ? ").append("(@.").append(key).append(" like_regex \"").append(PGJPAAnySearchDAO.escapeForLikeRegex(value).replace("%", ".*")).append("\"").append(lower ? " flag \"i\"" : "").append(")')");
                    break;
                }
                LOG.error("LIKE is only compatible with string or enum schemas");
                clause.append(' ').append("1=2");
                break;
            }
            default: {
                clause.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*] ? ").append("(@.").append(key);
                if (StringUtils.containsAny((CharSequence)value, (CharSequence)REGEX_CHARS) || lower) {
                    clause.append(" like_regex \"^").append(PGJPAAnySearchDAO.escapeForLikeRegex(value).replace("'", "''")).append("$\"");
                } else {
                    clause.append(" == ").append(PGJPAAnySearchDAO.escapeIfString(value, isStr));
                }
                clause.append(lower ? " flag \"i\"" : "").append(")')");
                break;
            }
            case GE: {
                clause.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*] ? ").append("(@.").append(key).append(" >= ").append(PGJPAAnySearchDAO.escapeIfString(value, isStr)).append(")')");
                break;
            }
            case GT: {
                clause.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*] ? ").append("(@.").append(key).append(" > ").append(PGJPAAnySearchDAO.escapeIfString(value, isStr)).append(")')");
                break;
            }
            case LE: {
                clause.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*] ? ").append("(@.").append(key).append(" <= ").append(PGJPAAnySearchDAO.escapeIfString(value, isStr)).append(")')");
                break;
            }
            case LT: {
                clause.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*] ? ").append("(@.").append(key).append(" < ").append(PGJPAAnySearchDAO.escapeIfString(value, isStr)).append(")')");
            }
        }
        if (not) {
            clause.insert(0, "NOT ");
        }
        return new AnySearchNode.Leaf(from, clause.toString());
    }

    @Override
    protected AbstractJPAAnySearchDAO.AttrCondQuery getQuery(AttrCond cond, boolean not, AbstractAnySearchDAO.CheckResult<AttrCond> checked, List<Object> parameters, SearchSupport svs) {
        if (not) {
            if (cond.getType() == AttrCond.Type.ISNULL) {
                cond.setType(AttrCond.Type.ISNOTNULL);
            } else if (cond.getType() == AttrCond.Type.ISNOTNULL) {
                cond.setType(AttrCond.Type.ISNULL);
            }
        }
        return switch (cond.getType()) {
            case AttrCond.Type.ISNOTNULL -> new AbstractJPAAnySearchDAO.AttrCondQuery(true, new AnySearchNode.Leaf(svs.table(), "jsonb_path_exists(" + checked.schema().getKey() + ",'$[*]')"));
            case AttrCond.Type.ISNULL -> new AbstractJPAAnySearchDAO.AttrCondQuery(true, new AnySearchNode.Leaf(svs.table(), "NOT jsonb_path_exists(" + checked.schema().getKey() + ",'$[*]')"));
            default -> new AbstractJPAAnySearchDAO.AttrCondQuery(true, this.filJSONAttrQuery(svs.table(), checked.value(), checked.schema(), cond, not));
        };
    }

    @Override
    protected void visitNode(AnySearchNode node, Map<SearchSupport.SearchView, Boolean> counters, Set<SearchSupport.SearchView> from, List<String> where, SearchSupport svs) {
        counters.clear();
        super.visitNode(node, counters, from, where, svs);
    }

    @Override
    protected String buildFrom(Set<SearchSupport.SearchView> from, Set<String> plainSchemas, OrderBySupport obs) {
        StringBuilder clause = new StringBuilder(super.buildFrom(from, plainSchemas, obs));
        HashSet<String> schemas = new HashSet<String>(plainSchemas);
        if (obs != null) {
            obs.items.forEach(item -> {
                String schema = StringUtils.substringBefore((String)item.orderBy, (int)32);
                if (StringUtils.isNotBlank((CharSequence)schema)) {
                    schemas.add(schema);
                }
            });
        }
        schemas.forEach(schema -> this.plainSchemaDAO.findById(schema).ifPresent(pschema -> clause.append(',').append("jsonb_path_query_array(plainattrs, '$[*] ? (@.schema==\"").append((String)schema).append("\").").append("\"").append(pschema.isUniqueConstraint() ? "uniqueValue" : "values").append("\"')").append(" AS ").append((String)schema)));
        return clause.toString();
    }
}

