/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.StatusR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.beans.ComplianceQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="UserSelf")
@Path(value="users/self")
public interface UserSelfService
extends JAXRSService {
    @Operation(security={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Calling user data, including own UUID, entitlements and delegations", content={@Content(schema=@Schema(implementation=UserTO.class))}, headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="UUID of the calling user"), @Header(name="X-Syncope-Entitlements", schema=@Schema(type="string"), description="List of entitlements owned by the calling user")})})
    @GET
    @Produces(value={"application/json"})
    public Response read();

    @Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"}))
    @ApiResponses(value={@ApiResponse(responseCode="201", description="User successfully created enriched with propagation status information, as Entity, or empty if 'Prefer: return-no-content' was specified", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}, headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="UUID generated for the user created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the user created"), @Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response create(@NotNull UserCR var1);

    @Operation(security={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="key", description="User's key", in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User successfully updated enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @PATCH
    @Path(value="{key}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response update(@NotNull UserUR var1);

    @Operation(security={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="key", description="User's key", in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User successfully updated enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @PUT
    @Path(value="{key}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response update(@NotNull UserTO var1);

    @Operation(security={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="key", description="User's key", in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User successfully updated enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Path(value="{key}/status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response status(@NotNull StatusR var1);

    @Operation(security={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
    @DELETE
    @Produces(value={"application/json"})
    public Response delete();

    @Operation(security={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
    @POST
    @Path(value="mustChangePassword")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response mustChangePassword(@NotNull PasswordPatch var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @Operation(security={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
    @POST
    @Path(value="compliance")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public void compliance(@NotNull ComplianceQuery var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="requestPasswordReset")
    @Produces(value={"application/json"})
    public void requestPasswordReset(@NotNull @QueryParam(value="username") String var1, String var2);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="confirmPasswordReset")
    @Produces(value={"application/json"})
    public void confirmPasswordReset(@NotNull @QueryParam(value="token") String var1, String var2);
}

