/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.saml2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.syncope.common.lib.Attr;

public class SAML2LoginResponse
implements Serializable {
    private static final long serialVersionUID = 794772343787258010L;
    private String nameID;
    private String sessionIndex;
    private Date notOnOrAfter;
    private String accessToken;
    private OffsetDateTime accessTokenExpiryTime;
    private String username;
    private final Set<Attr> attrs = new HashSet<Attr>();
    private String idp;
    private boolean sloSupported;
    private boolean selfReg;

    public String getNameID() {
        return this.nameID;
    }

    public void setNameID(String nameID) {
        this.nameID = nameID;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(String sessionIndex) {
        this.sessionIndex = sessionIndex;
    }

    public Date getNotOnOrAfter() {
        return Optional.ofNullable(this.notOnOrAfter).map(date -> new Date(date.getTime())).orElse(null);
    }

    public void setNotOnOrAfter(Date notOnOrAfter) {
        this.notOnOrAfter = Optional.ofNullable(notOnOrAfter).map(date -> new Date(date.getTime())).orElse(null);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public OffsetDateTime getAccessTokenExpiryTime() {
        return this.accessTokenExpiryTime;
    }

    public void setAccessTokenExpiryTime(OffsetDateTime accessTokenExpiryTime) {
        this.accessTokenExpiryTime = accessTokenExpiryTime;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    public Optional<Attr> getAttr(String schema) {
        return this.attrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    public Set<Attr> getAttrs() {
        return this.attrs;
    }

    public String getIdp() {
        return this.idp;
    }

    public void setIdp(String idp) {
        this.idp = idp;
    }

    public boolean isSloSupported() {
        return this.sloSupported;
    }

    public void setSloSupported(boolean sloSupported) {
        this.sloSupported = sloSupported;
    }

    public boolean isSelfReg() {
        return this.selfReg;
    }

    public void setSelfReg(boolean selfReg) {
        this.selfReg = selfReg;
    }
}

