/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope.passwordless;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.api.PasswordlessAuthenticationRequest;
import org.apereo.cas.api.PasswordlessUserAccount;
import org.apereo.cas.api.PasswordlessUserAccountCustomizer;
import org.apereo.cas.api.PasswordlessUserAccountStore;
import org.apereo.cas.configuration.model.support.passwordless.account.PasswordlessAuthenticationSyncopeAccountsProperties;
import org.apereo.cas.configuration.model.support.syncope.BaseSyncopeSearchProperties;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.apereo.cas.syncope.SyncopeUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;

public class SyncopePasswordlessUserAccountStore
implements PasswordlessUserAccountStore {
    private final List<PasswordlessUserAccountCustomizer> customizerList;
    private final PasswordlessAuthenticationSyncopeAccountsProperties properties;

    public Optional<? extends PasswordlessUserAccount> findUser(PasswordlessAuthenticationRequest request) {
        Optional<? extends PasswordlessUserAccount> account = this.locatePasswordlessAccount(request);
        this.customizerList.stream().filter(BeanSupplier::isNotProxy).forEach(customizer -> customizer.customize(account));
        return account;
    }

    protected Optional<? extends PasswordlessUserAccount> locatePasswordlessAccount(PasswordlessAuthenticationRequest request) {
        List<Map<String, List<Object>>> results = SyncopeUtils.syncopeUserSearch((BaseSyncopeSearchProperties)this.properties, request.getUsername());
        if (results.size() == 1) {
            Map<String, List<Object>> syncopeUser = results.getFirst();
            return Optional.of(PasswordlessUserAccount.builder().username(this.getPasswordlessUserAttribute(syncopeUser, "username")).name(this.getPasswordlessUserAttribute(syncopeUser, "name")).email(this.getPasswordlessUserAttribute(syncopeUser, "email")).phone(this.getPasswordlessUserAttribute(syncopeUser, "phoneNumber")).requestPassword(BooleanUtils.toBoolean((String)this.getPasswordlessUserAttribute(syncopeUser, "requestPassword"))).multifactorAuthenticationEligible(TriStateBoolean.fromBoolean((boolean)BooleanUtils.toBoolean((String)this.getPasswordlessUserAttribute(syncopeUser, "multifactorAuthenticationEligible")))).delegatedAuthenticationEligible(TriStateBoolean.fromBoolean((boolean)BooleanUtils.toBoolean((String)this.getPasswordlessUserAttribute(syncopeUser, "delegatedAuthenticationEligible")))).allowSelectionMenu(BooleanUtils.toBoolean((String)this.getPasswordlessUserAttribute(syncopeUser, "allowSelectionMenu"))).build());
        }
        return Optional.empty();
    }

    protected String getPasswordlessUserAttribute(Map<String, List<Object>> syncopeUser, String attributeName) {
        return syncopeUser.containsKey(attributeName) ? syncopeUser.get(attributeName).getFirst().toString() : null;
    }

    @Generated
    public SyncopePasswordlessUserAccountStore(List<PasswordlessUserAccountCustomizer> customizerList, PasswordlessAuthenticationSyncopeAccountsProperties properties) {
        this.customizerList = customizerList;
        this.properties = properties;
    }
}

