/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.cumulative.CumulativeTimer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.registry.otlp.OtlpHistogramSupport;
import io.micrometer.registry.otlp.StartTimeAwareMeter;
import io.micrometer.registry.otlp.internal.Base2ExponentialHistogram;
import io.micrometer.registry.otlp.internal.ExponentialHistogramSnapShot;
import java.util.concurrent.TimeUnit;

class OtlpCumulativeTimer
extends CumulativeTimer
implements StartTimeAwareMeter,
OtlpHistogramSupport {
    private final long startTimeNanos;

    OtlpCumulativeTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit, Histogram histogram) {
        super(id, clock, distributionStatisticConfig, pauseDetector, baseTimeUnit, histogram);
        this.startTimeNanos = TimeUnit.MILLISECONDS.toNanos(clock.wallTime());
    }

    @Override
    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    @Override
    @Nullable
    public ExponentialHistogramSnapShot getExponentialHistogramSnapShot() {
        if (this.histogram instanceof Base2ExponentialHistogram) {
            return ((Base2ExponentialHistogram)this.histogram).getLatestExponentialHistogramSnapshot();
        }
        return null;
    }
}

