/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;

@Schema(allOf={AnyTO.class})
public class AnyObjectTO
extends AnyTO
implements GroupableRelatableTO {
    private static final long serialVersionUID = 8841697496476959639L;
    private String name;
    private final List<MembershipTO> memberships = new ArrayList<MembershipTO>();

    @Override
    @JsonProperty(value="_class")
    @Schema(name="_class", requiredMode=Schema.RequiredMode.REQUIRED, example="org.apache.syncope.common.lib.to.AnyObjectTO")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public Optional<MembershipTO> getMembership(String groupKey) {
        return this.memberships.stream().filter(membership -> groupKey.equals(membership.getGroupKey())).findFirst();
    }

    @Override
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.name).append(this.memberships).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyObjectTO other = (AnyObjectTO)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.name, (Object)other.name).append(this.memberships, other.memberships).build();
    }
}

