/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.adaptive.intel;

import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.intel.IPAddressIntelligenceResponse;
import org.apereo.cas.authentication.adaptive.intel.IPAddressIntelligenceService;
import org.apereo.cas.configuration.model.core.authentication.AdaptiveAuthenticationProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.springframework.webflow.execution.RequestContext;

public abstract class BaseIPAddressIntelligenceService
implements IPAddressIntelligenceService {
    protected final TenantExtractor tenantExtractor;
    protected final AdaptiveAuthenticationProperties adaptiveAuthenticationProperties;

    private static void trackResponseInRequestContext(RequestContext context, IPAddressIntelligenceResponse response) {
        context.getFlowScope().put("ipAddressIntelligenceResponse", (Object)response);
    }

    public IPAddressIntelligenceResponse examine(RequestContext context, String clientIpAddress) throws Throwable {
        if (this.isClientIpAddressRejected(clientIpAddress)) {
            IPAddressIntelligenceResponse response = IPAddressIntelligenceResponse.banned();
            BaseIPAddressIntelligenceService.trackResponseInRequestContext(context, response);
            return response;
        }
        IPAddressIntelligenceResponse response = this.examineInternal(context, clientIpAddress);
        BaseIPAddressIntelligenceService.trackResponseInRequestContext(context, response);
        return response;
    }

    protected abstract IPAddressIntelligenceResponse examineInternal(RequestContext var1, String var2) throws Throwable;

    private boolean isClientIpAddressRejected(String clientIp) {
        String rejectIpAddresses = this.adaptiveAuthenticationProperties.getPolicy().getRejectIpAddresses();
        return StringUtils.isNotBlank((CharSequence)rejectIpAddresses) && Pattern.compile(rejectIpAddresses).matcher(clientIp).find();
    }

    @Generated
    protected BaseIPAddressIntelligenceService(TenantExtractor tenantExtractor, AdaptiveAuthenticationProperties adaptiveAuthenticationProperties) {
        this.tenantExtractor = tenantExtractor;
        this.adaptiveAuthenticationProperties = adaptiveAuthenticationProperties;
    }
}

