/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.azure.ad.authentication;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.model.support.azuread.AzureActiveDirectoryAuthenticationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class AzureActiveDirectoryAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureActiveDirectoryAuthenticationHandler.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().singleValueAsArray(true).build().toObjectMapper();
    private final AzureActiveDirectoryAuthenticationProperties properties;

    public AzureActiveDirectoryAuthenticationHandler(PrincipalFactory principalFactory, AzureActiveDirectoryAuthenticationProperties properties) {
        super(properties.getName(), principalFactory, Integer.valueOf(properties.getOrder()));
        this.properties = properties;
    }

    private String getUserInfoFromGraph(IAuthenticationResult authenticationResult, String username) throws Exception {
        URL url = new URI(Strings.CI.appendIfMissing(this.properties.getResource(), (CharSequence)"/", new CharSequence[0]) + "v1.0/users/" + username).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "Bearer " + authenticationResult.accessToken());
        conn.setRequestProperty("Accept", "application/json");
        LOGGER.debug("Fetching user info from [{}] using access token [{}]", (Object)url.toExternalForm(), (Object)authenticationResult.accessToken());
        int httpResponseCode = conn.getResponseCode();
        if (HttpStatus.valueOf((int)httpResponseCode).is2xxSuccessful()) {
            try (InputStream in = conn.getInputStream();){
                String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
        String msg = String.format("Failed: status %s with message: %s", httpResponseCode, conn.getResponseMessage());
        throw new FailedLoginException(msg);
        finally {
            conn.disconnect();
        }
    }

    protected IAuthenticationResult getAccessTokenFromUserCredentials(String username, String password) throws Exception {
        String clientId = SpringExpressionLanguageValueResolver.getInstance().resolve(this.properties.getClientId());
        Set scopes = StringUtils.commaDelimitedListToSet((String)this.properties.getScope());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.properties.getClientSecret())) {
            String clientSecret = SpringExpressionLanguageValueResolver.getInstance().resolve(this.properties.getClientSecret());
            IClientSecret clientCredential = ClientCredentialFactory.createFromSecret((String)clientSecret);
            ConfidentialClientApplication context = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)clientId, (IClientCredential)clientCredential).authority(this.properties.getLoginUrl())).validateAuthority(true)).build();
            String resource = Strings.CI.appendIfMissing(this.properties.getResource(), (CharSequence)"/", new CharSequence[0]).concat(".default");
            ClientCredentialParameters parameters = ClientCredentialParameters.builder(Set.of(resource)).tenant(this.properties.getTenant()).build();
            LOGGER.debug("Acquiring token for [{}] with tenant [{}] for resource [{}]", new Object[]{username, this.properties.getTenant(), resource});
            CompletableFuture future = context.acquireToken(parameters);
            return (IAuthenticationResult)future.get();
        }
        PublicClientApplication context = ((PublicClientApplication.Builder)((PublicClientApplication.Builder)PublicClientApplication.builder((String)clientId).authority(this.properties.getLoginUrl())).validateAuthority(true)).build();
        UserNamePasswordParameters parameters = UserNamePasswordParameters.builder((Set)scopes, (String)username, (char[])password.toCharArray()).tenant(SpringExpressionLanguageValueResolver.getInstance().resolve(this.properties.getTenant())).build();
        LOGGER.debug("Acquiring token for [{}] with tenant [{}] scopes [{}]", new Object[]{username, this.properties.getTenant(), scopes});
        CompletableFuture future = context.acquireToken(parameters);
        return (IAuthenticationResult)future.get();
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws Throwable {
        try {
            String username = credential.getUsername();
            LOGGER.trace("Fetching token for [{}]", (Object)username);
            IAuthenticationResult result = this.getAccessTokenFromUserCredentials(username, credential.toPassword());
            LOGGER.debug("Retrieved token [{}] for [{}]", (Object)result.accessToken(), (Object)username);
            String userInfo = this.getUserInfoFromGraph(result, username);
            LOGGER.trace("Retrieved user info [{}]", (Object)userInfo);
            Map userInfoMap = (Map)MAPPER.readValue(JsonValue.readHjson((String)userInfo).toString(), Map.class);
            HashMap attributeMap = new HashMap(userInfoMap.size());
            userInfoMap.forEach((key, value) -> {
                ArrayList values = (ArrayList)CollectionUtils.toCollection((Object)value, ArrayList.class);
                if (!values.isEmpty()) {
                    attributeMap.put(key, values);
                }
            });
            Principal principal = this.principalFactory.createPrincipal(username, attributeMap);
            LOGGER.debug("Created principal for id [{}] and [{}] attributes", (Object)username, attributeMap);
            return this.createHandlerResult((Credential)credential, principal, new ArrayList());
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new FailedLoginException("Invalid credentials: " + e.getMessage());
        }
    }
}

