/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit.support;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.audit.InMemoryAuditEventRepository;

public class DelegatingAuditEventRepository
implements AuditEventRepository {
    private final ObjectProvider<CasEventRepository> casEventRepository;
    private final AuditEventRepository auditEventRepository = new InMemoryAuditEventRepository();

    public void add(AuditEvent event) {
        Map eventData = event.getData();
        if (!(eventData == null || eventData.containsKey("source") && "CAS".equalsIgnoreCase(eventData.get("source").toString()))) {
            this.casEventRepository.ifAvailable(Unchecked.consumer(repo -> {
                ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
                CasEvent casEvent = new CasEvent();
                casEvent.setPrincipalId(event.getPrincipal());
                casEvent.setType(event.getType());
                casEvent.putTimestamp(Long.valueOf(event.getTimestamp().toEpochMilli()));
                casEvent.setCreationTime(event.getTimestamp());
                casEvent.putEventId(event.getType());
                if (clientInfo != null) {
                    casEvent.putClientIpAddress(clientInfo.getClientIpAddress());
                    casEvent.putServerIpAddress(clientInfo.getServerIpAddress());
                    casEvent.putAgent(clientInfo.getUserAgent());
                    GeoLocationRequest geoLocationRequest = HttpRequestUtils.getHttpServletRequestGeoLocation((String)clientInfo.getGeoLocation());
                    casEvent.putGeoLocation(geoLocationRequest);
                    casEvent.putTenant(clientInfo.getTenant());
                }
                repo.save(casEvent);
            }));
        }
        this.auditEventRepository.add(event);
    }

    public List<AuditEvent> find(String principal, Instant after, String type) {
        ArrayList<AuditEvent> results = new ArrayList<AuditEvent>();
        this.casEventRepository.ifAvailable(repo -> {
            if (StringUtils.isNotBlank((CharSequence)principal) && after != null && StringUtils.isNotBlank((CharSequence)type)) {
                results.addAll(repo.getEventsOfTypeForPrincipal(type, principal, after.atZone(ZoneOffset.UTC)).map(DelegatingAuditEventRepository::auditEventMapper).toList());
            } else if (StringUtils.isNotBlank((CharSequence)principal) && after != null) {
                results.addAll(repo.getEventsForPrincipal(principal, after.atZone(ZoneOffset.UTC)).map(DelegatingAuditEventRepository::auditEventMapper).toList());
            } else if (StringUtils.isNotBlank((CharSequence)principal) && StringUtils.isNotBlank((CharSequence)type)) {
                results.addAll(repo.getEventsOfTypeForPrincipal(type, principal).map(DelegatingAuditEventRepository::auditEventMapper).toList());
            } else if (StringUtils.isNotBlank((CharSequence)type) && after != null) {
                results.addAll(repo.getEventsOfType(type, after.atZone(ZoneOffset.UTC)).map(DelegatingAuditEventRepository::auditEventMapper).toList());
            } else if (StringUtils.isNotBlank((CharSequence)principal)) {
                results.addAll(repo.getEventsForPrincipal(principal).map(DelegatingAuditEventRepository::auditEventMapper).toList());
            } else if (StringUtils.isNotBlank((CharSequence)type)) {
                results.addAll(repo.getEventsOfType(type).map(DelegatingAuditEventRepository::auditEventMapper).toList());
            }
        });
        if (results.isEmpty()) {
            results.addAll(this.auditEventRepository.find(principal, after, type));
        }
        return results;
    }

    private static AuditEvent auditEventMapper(CasEvent event) {
        return new AuditEvent(event.getCreationTime(), event.getPrincipalId(), event.getType(), new HashMap(event.getProperties()));
    }

    @Generated
    public DelegatingAuditEventRepository(ObjectProvider<CasEventRepository> casEventRepository) {
        this.casEventRepository = casEventRepository;
    }
}

