/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.apache.syncope.common.lib.command.CommandOutput;
import org.apache.syncope.common.lib.command.CommandTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.rest.api.beans.CommandQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Commands")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="commands")
public interface CommandService
extends JAXRSService {
    @GET
    @Produces(value={"application/json"})
    public PagedResult<CommandTO> search(@BeanParam CommandQuery var1);

    @Parameter(name="key", description="Command's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @GET
    @Path(value="{key}")
    @Produces(value={"application/json"})
    public CommandTO read(@PathParam(value="key") String var1);

    @Parameter(name="key", description="Command's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @POST
    @Path(value="{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandOutput run(CommandTO var1);
}

