/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.ChainingMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidationResult;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

public class DefaultMultifactorAuthenticationContextValidator
implements MultifactorAuthenticationContextValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMultifactorAuthenticationContextValidator.class);
    private final String authenticationContextAttribute;
    private final String mfaTrustedAuthnAttributeName;
    private final ConfigurableApplicationContext applicationContext;

    private static Optional<MultifactorAuthenticationProvider> locateRequestedProvider(Collection<MultifactorAuthenticationProvider> providersArray, String requestedProvider) {
        return providersArray.stream().filter(BeanSupplier::isNotProxy).filter(provider -> Strings.CI.equals(provider.getId(), requestedProvider)).findFirst();
    }

    public MultifactorAuthenticationContextValidationResult validate(Authentication authentication, String requestedContext, Optional<RegisteredService> service) {
        Map<String, MultifactorAuthenticationProvider> providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        LOGGER.trace("Available multifactor providers are [{}]", providerMap.values());
        LOGGER.trace("Attempting to match requested authentication context [{}] against [{}]", (Object)requestedContext, providerMap.keySet());
        Optional<MultifactorAuthenticationProvider> requestedProvider = DefaultMultifactorAuthenticationContextValidator.locateRequestedProvider(providerMap.values(), requestedContext);
        if (requestedProvider.isEmpty()) {
            LOGGER.debug("Requested authentication provider cannot be recognized.");
            return MultifactorAuthenticationContextValidationResult.builder().success(false).provider(requestedProvider).build();
        }
        Set authnContextAttributes = StringUtils.commaDelimitedListToSet((String)this.authenticationContextAttribute);
        Map attributes = authentication.getAttributes();
        for (String authnContextAttribute : authnContextAttributes) {
            List ctxAttr = (List)attributes.get(authnContextAttribute);
            Set contexts = CollectionUtils.toCollection((Object)ctxAttr);
            LOGGER.debug("Requested context is [{}] and available contexts are [{}]", (Object)requestedContext, (Object)contexts);
            if (contexts.stream().anyMatch(ctx -> Strings.CI.equals(ctx.toString(), requestedContext))) {
                LOGGER.debug("Requested authentication context [{}] is satisfied", (Object)requestedContext);
                return MultifactorAuthenticationContextValidationResult.builder().success(true).provider(requestedProvider).build();
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.mfaTrustedAuthnAttributeName) && attributes.containsKey(this.mfaTrustedAuthnAttributeName)) {
                LOGGER.debug("Requested authentication context [{}] is satisfied since device is already trusted", (Object)requestedContext);
                return MultifactorAuthenticationContextValidationResult.builder().success(true).provider(requestedProvider).build();
            }
            MultifactorAuthenticationProvider provider = requestedProvider.get();
            Collection<MultifactorAuthenticationProvider> satisfiedProviders = this.getSatisfiedAuthenticationProviders(authentication, providerMap.values());
            if (satisfiedProviders == null || satisfiedProviders.isEmpty()) continue;
            MultifactorAuthenticationProvider[] providers = (MultifactorAuthenticationProvider[])satisfiedProviders.toArray(MultifactorAuthenticationProvider[]::new);
            OrderComparator.sortIfNecessary((Object)providers);
            LOGGER.debug("Satisfied authentication context(s) are [{}]", satisfiedProviders);
            Optional<MultifactorAuthenticationProvider> result = Arrays.stream(providers).filter(p -> p.equals((Object)provider) || p.getOrder() >= provider.getOrder()).findFirst();
            if (!result.isPresent()) continue;
            LOGGER.debug("Current provider [{}] already satisfies the authentication requirements of [{}]; proceed with flow normally.", (Object)result.get(), requestedProvider);
            return MultifactorAuthenticationContextValidationResult.builder().success(true).provider(requestedProvider).build();
        }
        LOGGER.info("No multifactor providers could be located to satisfy the requested context for [{}]", (Object)requestedContext);
        return MultifactorAuthenticationContextValidationResult.builder().success(false).provider(requestedProvider).build();
    }

    protected Collection<MultifactorAuthenticationProvider> getSatisfiedAuthenticationProviders(Authentication authentication, Collection<MultifactorAuthenticationProvider> providers) {
        Set contexts = CollectionUtils.toCollection(authentication.getAttributes().get(this.authenticationContextAttribute));
        LOGGER.debug("Available authentication context(s) are [{}]", (Object)contexts);
        return providers.stream().map(provider -> {
            if (provider instanceof ChainingMultifactorAuthenticationProvider) {
                ChainingMultifactorAuthenticationProvider chain = (ChainingMultifactorAuthenticationProvider)provider;
                return chain.getMultifactorAuthenticationProviders();
            }
            return List.of(provider);
        }).flatMap(Collection::stream).sorted(Comparator.comparing(Ordered::getOrder)).filter(provider -> contexts.contains(provider.getId())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Generated
    public DefaultMultifactorAuthenticationContextValidator(String authenticationContextAttribute, String mfaTrustedAuthnAttributeName, ConfigurableApplicationContext applicationContext) {
        this.authenticationContextAttribute = authenticationContextAttribute;
        this.mfaTrustedAuthnAttributeName = mfaTrustedAuthnAttributeName;
        this.applicationContext = applicationContext;
    }

    @Generated
    public String getAuthenticationContextAttribute() {
        return this.authenticationContextAttribute;
    }

    @Generated
    public String getMfaTrustedAuthnAttributeName() {
        return this.mfaTrustedAuthnAttributeName;
    }

    @Generated
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

