/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.logging;

import java.util.Arrays;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.LogMessageSummarizer;
import org.slf4j.Logger;

public class DefaultLogMessageSummarizer
implements LogMessageSummarizer {
    public static final String SYSTEM_PROPERTY_LOG_SUMMARY_ENABLED = "LOG_SUMMARY_ENABLED";
    private static final int LINES_TO_SUMMARIZE = 4;

    public boolean shouldSummarize(Logger logger) {
        String propertyValue = System.getProperty(SYSTEM_PROPERTY_LOG_SUMMARY_ENABLED);
        if (StringUtils.isNotBlank((CharSequence)propertyValue)) {
            return BooleanUtils.toBoolean((String)propertyValue);
        }
        return !logger.isDebugEnabled();
    }

    public String summarizeStackTrace(String message, Throwable throwable) {
        StringBuilder builder = new StringBuilder((String)StringUtils.defaultIfBlank((CharSequence)message, (CharSequence)throwable.getClass().getName())).append('\n');
        Arrays.stream(throwable.getStackTrace()).limit(4L).forEach(trace -> {
            String error = String.format("\t%s:%s:%s%n", trace.getFileName(), trace.getMethodName(), trace.getLineNumber());
            builder.append(error);
        });
        return builder.toString();
    }
}

