/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorConfig;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import com.warrenstrange.googleauth.ICredentialRepository;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import com.warrenstrange.googleauth.KeyRepresentation;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.CoreGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.gauth.CasGoogleAuthenticator;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;

public class DefaultCasGoogleAuthenticator
implements CasGoogleAuthenticator {
    private final CasConfigurationProperties casProperties;
    private final TenantExtractor tenantExtractor;
    private ICredentialRepository credentialRepository;

    public GoogleAuthenticatorKey createCredentials() {
        return this.toAuthenticatorInstance().createCredentials();
    }

    public GoogleAuthenticatorKey createCredentials(String userName) {
        return this.toAuthenticatorInstance().createCredentials(userName);
    }

    public boolean authorize(String secret, int verificationCode) {
        return this.toAuthenticatorInstance().authorize(secret, verificationCode);
    }

    public int getTotpPassword(String secret) {
        return this.toAuthenticatorInstance().getTotpPassword(secret);
    }

    protected IGoogleAuthenticator toAuthenticatorInstance() {
        TenantDefinition tenantDefinition;
        ConfigurationPropertiesBindingContext bindingContext;
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        if (clientInfo != null && StringUtils.isNotBlank((CharSequence)clientInfo.getTenant()) && (bindingContext = (tenantDefinition = (TenantDefinition)this.tenantExtractor.getTenantsManager().findTenant(clientInfo.getTenant()).orElseThrow()).bindProperties()).isBound() && bindingContext.containsBindingFor(CoreGoogleAuthenticatorMultifactorProperties.class)) {
            CasConfigurationProperties properties = (CasConfigurationProperties)bindingContext.value();
            CoreGoogleAuthenticatorMultifactorProperties gauth = properties.getAuthn().getMfa().getGauth().getCore();
            return this.buildGoogleAuthenticatorFrom(gauth);
        }
        CoreGoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth().getCore();
        return this.buildGoogleAuthenticatorFrom(gauth);
    }

    protected GoogleAuthenticator buildGoogleAuthenticatorFrom(CoreGoogleAuthenticatorMultifactorProperties gauth) {
        GoogleAuthenticatorConfig.GoogleAuthenticatorConfigBuilder builder = new GoogleAuthenticatorConfig.GoogleAuthenticatorConfigBuilder();
        builder.setCodeDigits(gauth.getCodeDigits());
        builder.setTimeStepSizeInMillis(TimeUnit.SECONDS.toMillis(gauth.getTimeStepSize()));
        builder.setWindowSize(gauth.getWindowSize());
        builder.setKeyRepresentation(KeyRepresentation.BASE32);
        GoogleAuthenticator authenticator = new GoogleAuthenticator(builder.build());
        authenticator.setCredentialRepository(this.credentialRepository);
        return authenticator;
    }

    @Generated
    public DefaultCasGoogleAuthenticator(CasConfigurationProperties casProperties, TenantExtractor tenantExtractor) {
        this.casProperties = casProperties;
        this.tenantExtractor = tenantExtractor;
    }

    @Generated
    public TenantExtractor getTenantExtractor() {
        return this.tenantExtractor;
    }

    @Generated
    public ICredentialRepository getCredentialRepository() {
        return this.credentialRepository;
    }

    @Generated
    public void setCredentialRepository(ICredentialRepository credentialRepository) {
        this.credentialRepository = credentialRepository;
    }
}

