/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn;

import com.duosecurity.Client;
import com.duosecurity.model.AccessDevice;
import com.duosecurity.model.Application;
import com.duosecurity.model.AuthContext;
import com.duosecurity.model.AuthDevice;
import com.duosecurity.model.AuthResult;
import com.duosecurity.model.HealthCheckResponse;
import com.duosecurity.model.Location;
import com.duosecurity.model.Token;
import com.github.benmanes.caffeine.cache.Cache;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.authn.BaseDuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationResult;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityClient;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityUniversalPromptCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.duo.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.http.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalPromptDuoSecurityAuthenticationService
extends BaseDuoSecurityAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UniversalPromptDuoSecurityAuthenticationService.class);
    private final DuoSecurityClient duoClient;

    public UniversalPromptDuoSecurityAuthenticationService(DuoSecurityMultifactorAuthenticationProperties duoProperties, HttpClient httpClient, DuoSecurityClient duoClient, List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolver, Cache<String, DuoSecurityUserAccount> userAccountCache, TenantExtractor tenantExtractor) {
        super(duoProperties, httpClient, tenantExtractor, multifactorAuthenticationPrincipalResolver, userAccountCache);
        this.duoClient = duoClient;
    }

    @Override
    public DuoSecurityAuthenticationResult authenticateInternal(Credential credential) throws Exception {
        DuoSecurityUniversalPromptCredential duoCredential = (DuoSecurityUniversalPromptCredential)credential;
        LOGGER.trace("Exchanging Duo Security authorization code [{}]", (Object)credential.getId());
        String principalId = this.getDuoPrincipalId(duoCredential);
        Client client = this.duoClient.getInstance();
        Token result = client.exchangeAuthorizationCodeFor2FAResult(credential.getId(), principalId);
        LOGGER.debug("Validated Duo Security code [{}] with result [{}]", (Object)credential.getId(), (Object)result);
        String username = (String)StringUtils.defaultIfBlank((CharSequence)result.getPreferred_username(), (CharSequence)result.getSub());
        LinkedHashMap<String, List<Object>> attributes = new LinkedHashMap<String, List<Object>>();
        if (this.properties.isCollectDuoAttributes()) {
            attributes.putAll(this.collectDuoAuthenticationAttributes(result));
            attributes.putAll(this.collectDuoAuthenticationContextAttributes(result));
            attributes.putAll(this.collectDuoAuthenticationResultAttributes(result));
        }
        return DuoSecurityAuthenticationResult.builder().success(true).username(username).attributes(attributes).build();
    }

    protected Map<String, List<Object>> collectDuoAuthenticationAttributes(Token result) {
        LinkedHashMap<String, List<Object>> attributes = new LinkedHashMap<String, List<Object>>();
        this.collectDuoAttribute(attributes, "duoExp", CollectionUtils.wrap((Object)result.getExp()));
        this.collectDuoAttribute(attributes, "duoIss", CollectionUtils.wrap((Object)result.getIss()));
        this.collectDuoAttribute(attributes, "duoIat", CollectionUtils.wrap((Object)result.getIat()));
        this.collectDuoAttribute(attributes, "duoAuthTime", CollectionUtils.wrap((Object)result.getAuth_time()));
        this.collectDuoAttribute(attributes, "duoSub", CollectionUtils.wrap((Object)result.getSub()));
        this.collectDuoAttribute(attributes, "duoPreferredUsername", CollectionUtils.wrap((Object)result.getPreferred_username()));
        this.collectDuoAttribute(attributes, "duoAud", CollectionUtils.wrap((Object)result.getAud()));
        return attributes;
    }

    protected Map<String, List<Object>> collectDuoAuthenticationResultAttributes(Token result) {
        LinkedHashMap<String, List<Object>> attributes = new LinkedHashMap<String, List<Object>>();
        AuthResult authResult = result.getAuth_result();
        if (authResult != null) {
            this.collectDuoAttribute(attributes, "duoAuthResult", CollectionUtils.wrap((Object)authResult.getResult()));
            this.collectDuoAttribute(attributes, "duoAuthResultStatus", CollectionUtils.wrap((Object)authResult.getStatus()));
            this.collectDuoAttribute(attributes, "duoAuthResultStatusMessage", CollectionUtils.wrap((Object)authResult.getStatus_msg()));
        }
        return attributes;
    }

    protected Map<String, List<Object>> collectDuoAuthenticationContextAttributes(Token result) {
        AuthContext authContext = result.getAuth_context();
        LinkedHashMap<String, List<Object>> attributes = new LinkedHashMap<String, List<Object>>();
        if (authContext != null) {
            AuthDevice authDevice;
            Application application;
            this.collectDuoAttribute(attributes, "duoAuthCtxEventType", CollectionUtils.wrap((Object)authContext.getEvent_type()));
            this.collectDuoAttribute(attributes, "duoAuthCtxFactor", CollectionUtils.wrap((Object)authContext.getFactor()));
            this.collectDuoAttribute(attributes, "duoAuthCtxReason", CollectionUtils.wrap((Object)authContext.getReason()));
            this.collectDuoAttribute(attributes, "duoAuthCtxResult", CollectionUtils.wrap((Object)authContext.getResult()));
            this.collectDuoAttribute(attributes, "duoAuthCtxTimestamp", CollectionUtils.wrap((Object)authContext.getTimestamp()));
            this.collectDuoAttribute(attributes, "duoAuthCtxTxId", CollectionUtils.wrap((Object)authContext.getTxid()));
            this.collectDuoAttribute(attributes, "duoAuthCtxUserKey", CollectionUtils.wrap((Object)authContext.getUser().getKey()));
            AccessDevice accessDevice = authContext.getAccess_device();
            if (accessDevice != null) {
                Location accessLocation;
                if (StringUtils.isNotBlank((CharSequence)accessDevice.getHostname())) {
                    this.collectDuoAttribute(attributes, "duoAuthCtxAccessDeviceHostname", CollectionUtils.wrap((Object)accessDevice.getHostname()));
                }
                if (StringUtils.isNotBlank((CharSequence)accessDevice.getIp())) {
                    this.collectDuoAttribute(attributes, "duoAuthCtxAccessDeviceIp", CollectionUtils.wrap((Object)accessDevice.getIp()));
                }
                if ((accessLocation = accessDevice.getLocation()) != null) {
                    this.collectDuoAttribute(attributes, "duoAuthCtxAccessDeviceLocationCity", CollectionUtils.wrap((Object)accessLocation.getCity()));
                    this.collectDuoAttribute(attributes, "duoAuthCtxAccessDeviceLocationCountry", CollectionUtils.wrap((Object)accessLocation.getCountry()));
                    this.collectDuoAttribute(attributes, "duoAuthCtxAccessDeviceLocationState", CollectionUtils.wrap((Object)accessLocation.getState()));
                }
            }
            if ((application = authContext.getApplication()) != null) {
                this.collectDuoAttribute(attributes, "duoAuthCtxApplicationId", CollectionUtils.wrap((Object)application.getName()));
            }
            if ((authDevice = authContext.getAuth_device()) != null) {
                this.collectDuoAttribute(attributes, "duoAuthCtxAuthDeviceHostname", CollectionUtils.wrap((Object)authDevice.getName()));
                this.collectDuoAttribute(attributes, "duoAuthCtxAuthDeviceIp", CollectionUtils.wrap((Object)authDevice.getIp()));
                Location authLocation = authDevice.getLocation();
                if (authLocation != null) {
                    this.collectDuoAttribute(attributes, "duoAuthCtxAuthDeviceLocationCity", CollectionUtils.wrap((Object)authLocation.getCity()));
                    this.collectDuoAttribute(attributes, "duoAuthCtxAuthDeviceLocationCountry", CollectionUtils.wrap((Object)authLocation.getCountry()));
                    this.collectDuoAttribute(attributes, "duoAuthCtxAuthDeviceLocationState", CollectionUtils.wrap((Object)authLocation.getState()));
                }
            }
        }
        return attributes;
    }

    protected void collectDuoAttribute(Map<String, List<Object>> attributes, String name, List values) {
        if (values != null && !values.isEmpty()) {
            attributes.put(name, values);
        }
    }

    protected String getDuoPrincipalId(DuoSecurityUniversalPromptCredential duoCredential) {
        Principal principal = this.resolvePrincipal(duoCredential.getAuthentication().getPrincipal());
        String principalAttribute = this.properties.getPrincipalAttribute();
        if (principal.getAttributes().containsKey(principalAttribute)) {
            return ((List)principal.getAttributes().get(principalAttribute)).getFirst().toString();
        }
        return principal.getId();
    }

    public boolean ping() {
        try {
            HealthCheckResponse response = this.duoClient.getInstance().healthCheck();
            LOGGER.debug("Received Duo Security health check response [{}]", (Object)response);
            return true;
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            return false;
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniversalPromptDuoSecurityAuthenticationService)) {
            return false;
        }
        UniversalPromptDuoSecurityAuthenticationService other = (UniversalPromptDuoSecurityAuthenticationService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DuoSecurityClient this$duoClient = this.duoClient;
        DuoSecurityClient other$duoClient = other.duoClient;
        return !(this$duoClient == null ? other$duoClient != null : !this$duoClient.equals(other$duoClient));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UniversalPromptDuoSecurityAuthenticationService;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DuoSecurityClient $duoClient = this.duoClient;
        result = result * 59 + ($duoClient == null ? 43 : $duoClient.hashCode());
        return result;
    }

    @Generated
    public DuoSecurityClient getDuoClient() {
        return this.duoClient;
    }
}

