/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.MessageBundleProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.springframework.context.MessageSource;
import org.springframework.context.support.AbstractResourceBasedMessageSource;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

public class CasReloadableMessageBundle
extends ReloadableResourceBundleMessageSource {
    private final TenantExtractor tenantExtractor;

    public CasReloadableMessageBundle(TenantExtractor tenantExtractor, CasConfigurationProperties casProperties, Properties commonMessages) {
        this.tenantExtractor = tenantExtractor;
        this.configure((AbstractResourceBasedMessageSource)this, casProperties);
        this.setCommonMessages(commonMessages);
    }

    protected String getMessageInternal(String code, Object[] args, Locale locale) {
        TenantDefinition tenantDefinition;
        ConfigurationPropertiesBindingContext bindingContext;
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        if (clientInfo != null && StringUtils.isNotBlank((CharSequence)clientInfo.getTenant()) && (bindingContext = (tenantDefinition = (TenantDefinition)this.tenantExtractor.getTenantsManager().findTenant(clientInfo.getTenant()).orElseThrow()).bindProperties()).isBound() && bindingContext.containsBindingFor(MessageBundleProperties.class)) {
            CasConfigurationProperties properties = (CasConfigurationProperties)bindingContext.value();
            properties.getMessageBundle().getBaseNames().addAll(this.getBasenameSet());
            MessageSource bean = this.configure((AbstractResourceBasedMessageSource)new ReloadableResourceBundleMessageSource(), properties);
            return bean.getMessage(code, args, locale);
        }
        return super.getMessageInternal(code, args, locale);
    }

    private MessageSource configure(AbstractResourceBasedMessageSource bean, CasConfigurationProperties casProperties) {
        MessageBundleProperties mb = casProperties.getMessageBundle();
        bean.setDefaultEncoding(mb.getEncoding());
        bean.setCacheSeconds(Long.valueOf(Beans.newDuration((String)mb.getCacheSeconds()).toSeconds()).intValue());
        bean.setFallbackToSystemLocale(mb.isFallbackSystemLocale());
        bean.setUseCodeAsDefaultMessage(mb.isUseCodeMessage());
        bean.setBasenames(mb.getBaseNames().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        bean.setCommonMessages(this.getCommonMessages());
        return bean;
    }
}

