/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.generator;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.support.CasConfigurationJasyptCipherExecutor;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratedEvent;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreModifiedEvent;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.io.WatcherService;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

@Order
public class OidcDefaultJsonWebKeystoreGeneratorService
implements OidcJsonWebKeystoreGeneratorService,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcDefaultJsonWebKeystoreGeneratorService.class);
    private final OidcProperties oidcProperties;
    private final ConfigurableApplicationContext applicationContext;
    private WatcherService resourceWatcherService;

    public void destroy() {
        FunctionUtils.doIfNotNull((Object)this.resourceWatcherService, WatcherService::close);
    }

    @Override
    public Optional<Resource> find() throws Exception {
        AbstractResource resource = this.determineJsonWebKeystoreResource();
        return Optional.ofNullable(ResourceUtils.doesResourceExist((Resource)resource) ? resource : null);
    }

    @Override
    public JsonWebKeySet store(JsonWebKeySet jsonWebKeySet) throws Exception {
        AbstractResource resource = this.determineJsonWebKeystoreResource();
        if (ResourceUtils.isFile((Resource)resource)) {
            String data = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
            File location = resource.getFile();
            FileUtils.write((File)location, (CharSequence)data, (Charset)StandardCharsets.UTF_8);
            LOGGER.debug("Generated JSON web keystore at [{}]", (Object)location);
        }
        return jsonWebKeySet;
    }

    @Override
    public Resource generate() throws Exception {
        AbstractResource resource = this.determineJsonWebKeystoreResource();
        boolean isWatcherEnabled = this.oidcProperties.getJwks().getFileSystem().isWatcherEnabled();
        final ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        if (ResourceUtils.isFile((Resource)resource) && isWatcherEnabled && this.resourceWatcherService == null) {
            this.resourceWatcherService = new FileWatcherService(resource.getFile(), file -> new Consumer<File>(){

                @Override
                public void accept(File file) {
                    FunctionUtils.doUnchecked(__ -> {
                        if (OidcDefaultJsonWebKeystoreGeneratorService.this.applicationContext.isActive()) {
                            LOGGER.info("Publishing event to broadcast change in [{}]", (Object)file);
                            OidcDefaultJsonWebKeystoreGeneratorService.this.applicationContext.publishEvent((ApplicationEvent)new OidcJsonWebKeystoreModifiedEvent(this, file, clientInfo));
                        }
                    }, (Object[])new Object[0]);
                }
            });
            this.resourceWatcherService.start(resource.getFilename());
        }
        Resource resultingResource = this.generate((Resource)resource);
        this.applicationContext.publishEvent((ApplicationEvent)new OidcJsonWebKeystoreGeneratedEvent(this, resultingResource, clientInfo));
        return resultingResource;
    }

    protected Resource generate(Resource file) throws Exception {
        if (ResourceUtils.doesResourceExist((Resource)file)) {
            LOGGER.trace("Located JSON web keystore at [{}]", (Object)file);
            return file;
        }
        JsonWebKeySet jsonWebKeySet = OidcJsonWebKeystoreGeneratorService.generateJsonWebKeySet(this.oidcProperties);
        this.store(jsonWebKeySet);
        return file;
    }

    protected AbstractResource determineJsonWebKeystoreResource() throws Exception {
        String file = SpringExpressionLanguageValueResolver.getInstance().resolve(this.oidcProperties.getJwks().getFileSystem().getJwksFile());
        try {
            String jsonKeys = new JsonWebKeySet(file).toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
            return new ByteArrayResource(jsonKeys.getBytes(StandardCharsets.UTF_8), "OpenID Connect Keystore");
        }
        catch (Exception e) {
            LOGGER.debug("Given resource [{}] cannot be parsed as a raw JSON web keystore", (Object)file);
            LOGGER.trace(e.getMessage(), (Throwable)e);
            AbstractResource resource = ResourceUtils.getRawResourceFrom((String)file);
            if (ResourceUtils.doesResourceExist((String)file)) {
                try (InputStream is = resource.getInputStream();){
                    String jwks = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    if (CasConfigurationJasyptCipherExecutor.isValueEncrypted((String)jwks)) {
                        CasConfigurationJasyptCipherExecutor cipher = new CasConfigurationJasyptCipherExecutor((Environment)this.applicationContext.getEnvironment());
                        ByteArrayResource byteArrayResource = new ByteArrayResource(cipher.decryptValue(jwks).getBytes(StandardCharsets.UTF_8));
                        return byteArrayResource;
                    }
                }
            }
            return resource;
        }
    }

    @Generated
    public OidcDefaultJsonWebKeystoreGeneratorService(OidcProperties oidcProperties, ConfigurableApplicationContext applicationContext) {
        this.oidcProperties = oidcProperties;
        this.applicationContext = applicationContext;
    }
}

