/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.notifications.sms.SmsBodyBuilder;
import org.apereo.cas.notifications.sms.SmsRequest;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class NotifySingleSignOnEventAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifySingleSignOnEventAction.class);
    private final TicketRegistry ticketRegistry;
    private final CommunicationsManager communicationsManager;
    private final JwtBuilder jwtBuilder;
    private final CasConfigurationProperties casProperties;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        if (this.casProperties.getSso().getMail().isUndefined() && this.casProperties.getSso().getSms().isUndefined()) {
            LOGGER.debug("Communication settings for email/sms are undefined for single sign-on notifications. Skipping...");
            return this.eventFactory.event((Object)this, "skip");
        }
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        Ticket ticketGrantingTicket = this.ticketRegistry.getTicket(ticketGrantingTicketId);
        if (!(ticketGrantingTicket instanceof AuthenticationAwareTicket)) {
            LOGGER.debug("No ticket-granting ticket is found in the context for single sign-on notification events");
            return this.eventFactory.event((Object)this, "skip");
        }
        AuthenticationAwareTicket aat = (AuthenticationAwareTicket)ticketGrantingTicket;
        if (this.casProperties.getSso().getMail().isDefined()) {
            this.sendSingleSignOnEventEmail(requestContext, aat);
        }
        if (this.casProperties.getSso().getSms().isDefined()) {
            this.sendSingleSignOnEventSms(requestContext, aat);
        }
        return this.eventFactory.event((Object)this, "success");
    }

    protected void sendSingleSignOnEventSms(RequestContext context, AuthenticationAwareTicket aat) throws Throwable {
        String message = SmsBodyBuilder.builder().properties(this.casProperties.getSso().getSms()).parameters(this.buildCommunicationParameters(context, aat)).build().get();
        this.casProperties.getSso().getSms().getAttributeName().forEach(attribute -> {
            SmsRequest smsRequest = SmsRequest.builder().from(this.casProperties.getSso().getSms().getFrom()).text(message).principal(aat.getAuthentication().getPrincipal()).attribute(attribute).tenant(ClientInfoHolder.getClientInfo().getTenant()).build();
            LOGGER.debug("Attempting to send SMS [{}] to [{}]", (Object)message, (Object)smsRequest.getRecipients());
            this.communicationsManager.sms(smsRequest);
        });
    }

    protected void sendSingleSignOnEventEmail(RequestContext context, AuthenticationAwareTicket aat) throws Throwable {
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        String body = EmailMessageBodyBuilder.builder().properties(this.casProperties.getSso().getMail()).parameters(this.buildCommunicationParameters(context, aat)).build().get();
        this.casProperties.getSso().getMail().getAttributeName().forEach(attribute -> {
            EmailMessageRequest emailRequest = EmailMessageRequest.builder().emailProperties(this.casProperties.getSso().getMail()).tenant(clientInfo.getTenant()).principal(aat.getAuthentication().getPrincipal()).attribute(attribute).body(body).build();
            LOGGER.debug("Attempting to send email [{}] to [{}]", (Object)body, (Object)emailRequest.getRecipients());
            this.communicationsManager.email(emailRequest);
        });
    }

    protected Map<String, Object> buildCommunicationParameters(RequestContext context, AuthenticationAwareTicket aat) throws Throwable {
        Principal principal = aat.getAuthentication().getPrincipal();
        Date expiration = DateTimeUtils.dateOf((LocalDateTime)LocalDateTime.now(Clock.systemUTC()).plusSeconds(aat.getExpirationPolicy().getTimeToLive()));
        JwtBuilder.JwtRequest.JwtRequestBuilder builder = JwtBuilder.JwtRequest.builder();
        JwtBuilder.JwtRequest request = builder.serviceAudience(Set.of(this.casProperties.getServer().getPrefix())).issueDate(new Date()).jwtId(aat.getId()).subject(principal.getId()).validUntilDate(expiration).issuer(this.casProperties.getServer().getPrefix()).build();
        LOGGER.debug("Building JWT using [{}]", (Object)request);
        String token = this.jwtBuilder.build(request);
        return Map.of("requestContext", context, "token", token, "ticketGrantingTicket", aat.getId(), "clientInfo", ClientInfoHolder.getClientInfo(), "authentication", aat.getAuthentication(), "principal", principal, "principalId", principal.getId());
    }

    @Generated
    public NotifySingleSignOnEventAction(TicketRegistry ticketRegistry, CommunicationsManager communicationsManager, JwtBuilder jwtBuilder, CasConfigurationProperties casProperties) {
        this.ticketRegistry = ticketRegistry;
        this.communicationsManager = communicationsManager;
        this.jwtBuilder = jwtBuilder;
        this.casProperties = casProperties;
    }
}

