/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.util.lang.Generics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.kendo.ui.IKendoDataSource;
import org.wicketstuff.kendo.ui.KendoDestroyListener;
import org.wicketstuff.kendo.ui.settings.KendoUILibrarySettings;

public class KendoUIBehavior
extends JQueryBehavior
implements KendoDestroyListener.IDestroyable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(KendoUIBehavior.class);
    private List<IKendoDataSource> datasources = null;

    public KendoUIBehavior(String selector, String method) {
        this(selector, method, new Options());
    }

    public KendoUIBehavior(String selector, String method, Options options) {
        super(selector, method, options);
        this.initReferences();
    }

    private void initReferences() {
        KendoUILibrarySettings settings = KendoUILibrarySettings.get();
        if (settings.getCommonStyleSheetReference() != null) {
            this.add(settings.getCommonStyleSheetReference());
        }
        if (settings.getThemeStyleSheetReference() != null) {
            this.add(settings.getThemeStyleSheetReference());
        }
        if (settings.getMobileStyleSheetReference() != null) {
            this.add(settings.getMobileStyleSheetReference());
        }
        if (settings.getJavaScriptReference() != null) {
            this.add(settings.getJavaScriptReference());
        }
    }

    public boolean add(IKendoDataSource datasource) {
        if (this.datasources == null) {
            this.datasources = Generics.newArrayList();
        }
        return this.datasources.add(datasource);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        if (this.datasources != null) {
            for (IKendoDataSource datasource : this.datasources) {
                this.renderOnDomReadyScript(datasource.toScript(), response);
            }
        }
        super.renderHead(component, response);
    }

    public String widget() {
        return KendoUIBehavior.widget(this.selector, this.method);
    }

    protected String widget(String method) {
        return KendoUIBehavior.widget(this.selector, method);
    }

    public static String widget(String selector, String method) {
        return String.format("jQuery('%s').data('%s')", selector, method);
    }

    public static String widget(Component component, String method) {
        return KendoUIBehavior.widget(IJQueryWidget.JQueryWidget.getSelector((Component)component), method);
    }

    @Override
    public void destroy(IPartialPageRequestHandler handler) {
        handler.prependJavaScript((CharSequence)String.format("var $w = %s; if($w) { $w.destroy(); }", this.widget()));
        this.onDestroy(handler);
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (!Application.get().getMarkupSettings().getStripWicketTags()) {
            LOG.warn("Application > MarkupSettings > StripWicketTags: setting is currently set to false. It is highly recommended to set it to true to prevent widget misbehaviors.");
        }
    }

    protected void onDestroy(IPartialPageRequestHandler handler) {
    }
}

