/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.internals.IdempotentCloser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IdempotentCloserTest {
    private static final Runnable CALLBACK_NO_OP = () -> {};
    private static final Runnable CALLBACK_WITH_RUNTIME_EXCEPTION = () -> {
        throw new RuntimeException("Simulated error during callback");
    };

    @Test
    public void testBasicClose() {
        IdempotentCloser ic = new IdempotentCloser();
        Assertions.assertFalse((boolean)ic.isClosed());
        ic.close();
        Assertions.assertTrue((boolean)ic.isClosed());
    }

    @Test
    public void testCountCloses() {
        AtomicInteger onCloseCounter = new AtomicInteger();
        IdempotentCloser ic = new IdempotentCloser();
        Assertions.assertFalse((boolean)ic.isClosed());
        Assertions.assertEquals((int)0, (int)onCloseCounter.get());
        ic.close(onCloseCounter::getAndIncrement);
        Assertions.assertTrue((boolean)ic.isClosed());
        Assertions.assertEquals((int)1, (int)onCloseCounter.get());
        ic.close(onCloseCounter::getAndIncrement);
        Assertions.assertTrue((boolean)ic.isClosed());
        Assertions.assertEquals((int)1, (int)onCloseCounter.get());
    }

    @Test
    public void testEnsureIdempotentClose() {
        AtomicInteger onCloseCounter = new AtomicInteger();
        AtomicInteger onPreviousCloseCounter = new AtomicInteger();
        IdempotentCloser ic = new IdempotentCloser();
        Assertions.assertFalse((boolean)ic.isClosed());
        Assertions.assertEquals((int)0, (int)onCloseCounter.get());
        Assertions.assertEquals((int)0, (int)onPreviousCloseCounter.get());
        ic.close(onCloseCounter::getAndIncrement, onPreviousCloseCounter::getAndIncrement);
        Assertions.assertTrue((boolean)ic.isClosed());
        Assertions.assertEquals((int)1, (int)onCloseCounter.get());
        Assertions.assertEquals((int)0, (int)onPreviousCloseCounter.get());
        ic.close(onCloseCounter::getAndIncrement, onPreviousCloseCounter::getAndIncrement);
        Assertions.assertTrue((boolean)ic.isClosed());
        Assertions.assertEquals((int)1, (int)onCloseCounter.get());
        Assertions.assertEquals((int)1, (int)onPreviousCloseCounter.get());
        ic.close(onCloseCounter::getAndIncrement, onPreviousCloseCounter::getAndIncrement);
        Assertions.assertTrue((boolean)ic.isClosed());
        Assertions.assertEquals((int)1, (int)onCloseCounter.get());
        Assertions.assertEquals((int)2, (int)onPreviousCloseCounter.get());
    }

    @Test
    public void testCloseBeforeThrows() {
        IdempotentCloser ic = new IdempotentCloser();
        Assertions.assertFalse((boolean)ic.isClosed());
        Assertions.assertDoesNotThrow(() -> ic.assertOpen(() -> "test"));
        ic.close();
        Assertions.assertTrue((boolean)ic.isClosed());
        Assertions.assertThrows(IllegalStateException.class, () -> ic.assertOpen(() -> "test"));
    }

    @Test
    public void testErrorsInOnCloseCallbacksAreNotSwallowed() {
        IdempotentCloser ic = new IdempotentCloser();
        Assertions.assertFalse((boolean)ic.isClosed());
        Assertions.assertThrows(RuntimeException.class, () -> ic.close(CALLBACK_WITH_RUNTIME_EXCEPTION));
        Assertions.assertTrue((boolean)ic.isClosed());
    }

    @Test
    public void testErrorsInOnPreviousCloseCallbacksAreNotSwallowed() {
        IdempotentCloser ic = new IdempotentCloser();
        Assertions.assertFalse((boolean)ic.isClosed());
        ic.close(CALLBACK_NO_OP);
        Assertions.assertTrue((boolean)ic.isClosed());
        Assertions.assertThrows(RuntimeException.class, () -> ic.close(CALLBACK_NO_OP, CALLBACK_WITH_RUNTIME_EXCEPTION));
        Assertions.assertTrue((boolean)ic.isClosed());
    }

    @Test
    public void testCreatedClosed() {
        IdempotentCloser ic = new IdempotentCloser(true);
        Assertions.assertTrue((boolean)ic.isClosed());
        Assertions.assertThrows(IllegalStateException.class, () -> ic.assertOpen(() -> "test"));
        Assertions.assertDoesNotThrow(() -> ic.close(CALLBACK_WITH_RUNTIME_EXCEPTION));
    }
}

