/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.persistence.EntityManagerFactory;
import java.util.Set;
import javax.sql.DataSource;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.jpa.JpaConfigurationContext;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.impl.history.AmnesiacPasswordHistoryService;
import org.apereo.cas.pm.jdbc.JdbcPasswordHistoryEntity;
import org.apereo.cas.pm.jdbc.JdbcPasswordHistoryService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableTransactionManagement(proxyTargetClass=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PasswordManagementHistory}, module="jdbc")
@Configuration(value="JdbcPasswordHistoryManagementConfiguration", proxyBeanMethods=false)
class JdbcPasswordHistoryManagementConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.pm.history.core.enabled").isTrue();

    JdbcPasswordHistoryManagementConfiguration() {
    }

    @Configuration(value="JdbcPasswordHistoryManagementServiceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JdbcPasswordHistoryManagementServiceConfiguration {
        JdbcPasswordHistoryManagementServiceConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public PasswordHistoryService passwordHistoryService(ConfigurableApplicationContext applicationContext) {
            return (PasswordHistoryService)BeanSupplier.of(PasswordHistoryService.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(JdbcPasswordHistoryService::new).otherwise(AmnesiacPasswordHistoryService::new).get();
        }
    }

    @Configuration(value="JdbcPasswordHistoryManagementTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JdbcPasswordHistoryManagementTransactionConfiguration {
        JdbcPasswordHistoryManagementTransactionConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager transactionManagerPasswordHistory(ConfigurableApplicationContext applicationContext, @Qualifier(value="passwordHistoryEntityManagerFactory") FactoryBean<EntityManagerFactory> emf) {
            return (PlatformTransactionManager)BeanSupplier.of(PlatformTransactionManager.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
                JpaTransactionManager mgmr = new JpaTransactionManager();
                mgmr.setEntityManagerFactory((EntityManagerFactory)emf.getObject());
                return mgmr;
            })).otherwiseProxy().get();
        }
    }

    @Configuration(value="JdbcPasswordHistoryManagementEntityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JdbcPasswordHistoryManagementEntityConfiguration {
        JdbcPasswordHistoryManagementEntityConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public JpaVendorAdapter jpaPasswordHistoryVendorAdapter(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return (JpaVendorAdapter)BeanSupplier.of(JpaVendorAdapter.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc())).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<String> jpaPasswordHistoryPackagesToScan() {
            return BeanContainer.of((Set)CollectionUtils.wrapSet((Object)JdbcPasswordHistoryEntity.class.getPackage().getName()));
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FactoryBean<EntityManagerFactory> passwordHistoryEntityManagerFactory(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="jpaPasswordHistoryVendorAdapter") JpaVendorAdapter jpaPasswordHistoryVendorAdapter, @Qualifier(value="jpaPasswordHistoryPackagesToScan") BeanContainer<String> jpaPasswordHistoryPackagesToScan, @Qualifier(value="jdbcPasswordManagementDataSource") DataSource jdbcPasswordManagementDataSource, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return (FactoryBean)BeanSupplier.of(FactoryBean.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
                JpaConfigurationContext ctx = JpaConfigurationContext.builder().jpaVendorAdapter(jpaPasswordHistoryVendorAdapter).persistenceUnitName("jpaPasswordHistoryContext").dataSource(jdbcPasswordManagementDataSource).packagesToScan(jpaPasswordHistoryPackagesToScan.toSet()).build();
                return jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)casProperties.getAuthn().getPm().getJdbc());
            })).otherwiseProxy().get();
        }
    }
}

