/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.thymeleaf.context.WebEngineContext;
import org.thymeleaf.util.EvaluationUtils;

public class CasThymeleafTemplatesDirector {
    private final CasWebflowExecutionPlan webflowExecutionPlan;
    private final ThemeResolver themeResolver;
    private final ThemeSource themeSource;

    public String getUrlExternalForm(URL url) {
        String externalForm = url.toExternalForm();
        if (externalForm.contains("?")) {
            return externalForm + "&";
        }
        return externalForm + "?";
    }

    public String getExceptionClassSimpleName(Throwable ex) {
        return ex.getClass().getSimpleName();
    }

    public boolean isLoginFormViewable(WebEngineContext vars) {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        Collection providers = this.webflowExecutionPlan.getWebflowLoginContextProviders();
        return requestContext != null && (WebUtils.isCasLoginFormViewable((RequestContext)requestContext) || providers.isEmpty() || providers.stream().noneMatch(provider -> provider.isLoginFormViewable(requestContext)));
    }

    public boolean isLoginFormUsernameInputVisible(WebEngineContext vars) {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        Collection providers = this.webflowExecutionPlan.getWebflowLoginContextProviders();
        return requestContext != null && (WebUtils.isCasLoginFormViewable((RequestContext)requestContext) || providers.isEmpty() || providers.stream().anyMatch(provider -> provider.isLoginFormUsernameInputVisible(requestContext)));
    }

    public boolean isLoginFormUsernameInputDisabled(WebEngineContext vars) {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        return requestContext == null || !WebUtils.isCasLoginFormViewable((RequestContext)requestContext) || WebUtils.isGraphicalUserAuthenticationEnabled((RequestContext)requestContext) || this.webflowExecutionPlan.getWebflowLoginContextProviders().stream().anyMatch(provider -> provider.isLoginFormUsernameInputDisabled(requestContext));
    }

    public String getLoginFormUsername(WebEngineContext vars) {
        RequestContext context = RequestContextHolder.getRequestContext();
        if (context != null && WebUtils.isCasLoginFormViewable((RequestContext)context)) {
            return this.webflowExecutionPlan.getWebflowLoginContextProviders().stream().map(provider -> provider.getCandidateUsername(context)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse("");
        }
        return "";
    }

    public String format(LocalDateTime dateTime, String pattern) {
        return dateTime.format(DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH));
    }

    public Boolean isTrue(Object target) {
        String value;
        return target instanceof String && StringUtils.isBlank((CharSequence)(value = (String)target).trim()) ? Boolean.FALSE : EvaluationUtils.evaluateAsBoolean((Object)target);
    }

    public String theme(String code) {
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        Objects.requireNonNull(request, "Http request cannot be null or undefined");
        String themeName = this.themeResolver.resolveThemeName(request);
        Theme theme = this.themeSource.getTheme(themeName);
        Objects.requireNonNull(theme, "Theme cannot be null or undefined");
        return theme.getMessageSource().getMessage(code, null, "", request.getLocale());
    }

    @Generated
    public CasThymeleafTemplatesDirector(CasWebflowExecutionPlan webflowExecutionPlan, ThemeResolver themeResolver, ThemeSource themeSource) {
        this.webflowExecutionPlan = webflowExecutionPlan;
        this.themeResolver = themeResolver;
        this.themeSource = themeSource;
    }
}

