/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.deployer;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.eventregistry.impl.deployer.ParsedDeployment;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class ChannelDefinitionDeploymentHelper {
    public void verifyChannelDefinitionsDoNotShareKeys(Collection<ChannelDefinitionEntity> channelDefinitions) {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (ChannelDefinitionEntity channelDefinition : channelDefinitions) {
            if (keySet.contains(channelDefinition.getKey())) {
                throw new FlowableException("The deployment contains channel definition with the same key, this is not allowed");
            }
            keySet.add(channelDefinition.getKey());
        }
    }

    public void copyDeploymentValuesToEventDefinitions(EventDeploymentEntity deployment, List<ChannelDefinitionEntity> channelDefinitions) {
        String tenantId = deployment.getTenantId();
        String deploymentId = deployment.getId();
        for (ChannelDefinitionEntity channelDefinition : channelDefinitions) {
            if (tenantId != null) {
                channelDefinition.setTenantId(tenantId);
            }
            channelDefinition.setDeploymentId(deploymentId);
        }
    }

    public void setResourceNamesOnEventDefinitions(ParsedDeployment parsedDeployment) {
        for (ChannelDefinitionEntity channelDefinition : parsedDeployment.getAllChannelDefinitions()) {
            String resourceName = parsedDeployment.getResourceForChannelDefinition(channelDefinition).getName();
            channelDefinition.setResourceName(resourceName);
        }
    }

    public ChannelDefinitionEntity getMostRecentVersionOfChannelDefinition(ChannelDefinitionEntity channelDefinition) {
        String key = channelDefinition.getKey();
        String tenantId = channelDefinition.getTenantId();
        ChannelDefinitionEntityManager channelDefinitionEntityManager = CommandContextUtil.getEventRegistryConfiguration().getChannelDefinitionEntityManager();
        ChannelDefinitionEntity existingDefinition = null;
        existingDefinition = tenantId != null && !tenantId.equals("") ? channelDefinitionEntityManager.findLatestChannelDefinitionByKeyAndTenantId(key, tenantId) : channelDefinitionEntityManager.findLatestChannelDefinitionByKey(key);
        return existingDefinition;
    }

    public ChannelDefinitionEntity getPersistedInstanceOfChannelDefinition(ChannelDefinitionEntity channelDefinition) {
        String deploymentId = channelDefinition.getDeploymentId();
        if (StringUtils.isEmpty((CharSequence)channelDefinition.getDeploymentId())) {
            throw new FlowableIllegalArgumentException("Provided channel definition must have a deployment id.");
        }
        ChannelDefinitionEntityManager channelDefinitionEntityManager = CommandContextUtil.getEventRegistryConfiguration().getChannelDefinitionEntityManager();
        ChannelDefinitionEntity persistedChannelDefinition = null;
        persistedChannelDefinition = channelDefinition.getTenantId() == null || "".equals(channelDefinition.getTenantId()) ? channelDefinitionEntityManager.findChannelDefinitionByDeploymentAndKey(deploymentId, channelDefinition.getKey()) : channelDefinitionEntityManager.findChannelDefinitionByDeploymentAndKeyAndTenantId(deploymentId, channelDefinition.getKey(), channelDefinition.getTenantId());
        return persistedChannelDefinition;
    }
}

