/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.event;

import com.github.benmanes.caffeine.jcache.event.EventTypeAwareListener;
import java.util.Objects;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryEventFilter;
import org.jspecify.annotations.Nullable;

public final class Registration<K, V> {
    private final CacheEntryListenerConfiguration<K, V> configuration;
    private final EventTypeAwareListener<K, V> listener;
    private final CacheEntryEventFilter<K, V> filter;

    public Registration(CacheEntryListenerConfiguration<K, V> configuration, CacheEntryEventFilter<K, V> filter, EventTypeAwareListener<K, V> listener) {
        this.configuration = new MutableCacheEntryListenerConfiguration(configuration);
        this.listener = Objects.requireNonNull(listener);
        this.filter = Objects.requireNonNull(filter);
    }

    public CacheEntryListenerConfiguration<K, V> getConfiguration() {
        return this.configuration;
    }

    public EventTypeAwareListener<K, V> getCacheEntryListener() {
        return this.listener;
    }

    public CacheEntryEventFilter<K, V> getCacheEntryFilter() {
        return this.filter;
    }

    public boolean isSynchronous() {
        return this.configuration.isSynchronous();
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Registration)) {
            return false;
        }
        Registration other = (Registration)o;
        return this.configuration.equals(other.configuration);
    }

    public int hashCode() {
        return this.configuration.hashCode();
    }
}

