/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.LdapGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.gauth.CasGoogleAuthenticator;
import org.apereo.cas.gauth.credential.LdapGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.ldaptive.ConnectionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.GoogleAuthenticator}, module="ldap")
@AutoConfiguration
public class CasGoogleAuthenticatorLdapAutoConfiguration {
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"ldapGoogleAuthenticatorAccountRegistry"})
    public OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry(@Qualifier(value="googleAuthenticatorInstance") CasGoogleAuthenticator googleAuthenticatorInstance, @Qualifier(value="googleAuthenticatorAccountCipherExecutor") CipherExecutor googleAuthenticatorAccountCipherExecutor, @Qualifier(value="googleAuthenticatorScratchCodesCipherExecutor") CipherExecutor googleAuthenticatorScratchCodesCipherExecutor, CasConfigurationProperties casProperties) {
        LdapGoogleAuthenticatorMultifactorProperties ldap = casProperties.getAuthn().getMfa().getGauth().getLdap();
        ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
        return new LdapGoogleAuthenticatorTokenCredentialRepository((CipherExecutor<String, String>)googleAuthenticatorAccountCipherExecutor, (CipherExecutor<Number, Number>)googleAuthenticatorScratchCodesCipherExecutor, googleAuthenticatorInstance, connectionFactory, ldap);
    }
}

