/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityDirectCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityPasscodeCredential;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.metadata.BasicCredentialMetadata;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;

public class DuoSecurityRestHttpRequestCredentialFactory
implements RestHttpRequestCredentialFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DuoSecurityRestHttpRequestCredentialFactory.class);
    public static final String PARAMETER_NAME_PASSCODE = "passcode";
    public static final String PARAMETER_NAME_PROVIDER = "provider";
    protected final TenantExtractor tenantExtractor;

    public List<Credential> fromRequest(HttpServletRequest request, MultiValueMap<String, String> requestBody) throws Throwable {
        if (requestBody == null || requestBody.isEmpty()) {
            LOGGER.debug("Skipping [{}] because the request body is null or empty", (Object)this.getClass().getSimpleName());
            return new ArrayList<Credential>();
        }
        if (!requestBody.containsKey((Object)"username") || !requestBody.containsKey((Object)PARAMETER_NAME_PASSCODE)) {
            LOGGER.debug("No username or passcode provided");
            return new ArrayList<Credential>();
        }
        String username = FunctionUtils.throwIfBlank((String)((String)requestBody.getFirst((Object)"username")));
        String token = FunctionUtils.throwIfBlank((String)((String)requestBody.getFirst((Object)PARAMETER_NAME_PASSCODE)));
        String providerId = (String)StringUtils.defaultIfBlank((CharSequence)((String)requestBody.getFirst((Object)PARAMETER_NAME_PROVIDER)), (CharSequence)"mfa-duo");
        DuoSecurityPasscodeCredential credential = new DuoSecurityPasscodeCredential(username, token, providerId);
        BasicCredentialMetadata credentialMetadata = new BasicCredentialMetadata((Credential)credential);
        credentialMetadata.setTenant((String)this.tenantExtractor.extract(request).map(TenantDefinition::getId).orElse(null));
        return CollectionUtils.wrap((Object)this.prepareCredential(request, (Credential)credential));
    }

    public List<Credential> fromAuthentication(HttpServletRequest request, MultiValueMap<String, String> requestBody, Authentication authentication, MultifactorAuthenticationProvider provider) {
        Principal principal = authentication.getPrincipal();
        DuoSecurityDirectCredential credential = new DuoSecurityDirectCredential(principal, provider.getId());
        BasicCredentialMetadata credentialMetadata = new BasicCredentialMetadata((Credential)credential);
        credentialMetadata.setTenant((String)this.tenantExtractor.extract(request).map(TenantDefinition::getId).orElse(null));
        return List.of(this.prepareCredential(request, (Credential)credential));
    }

    @Generated
    public DuoSecurityRestHttpRequestCredentialFactory(TenantExtractor tenantExtractor) {
        this.tenantExtractor = tenantExtractor;
    }
}

