/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.provisioning.api.data.RoleDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class RoleLogic
extends AbstractTransactionalLogic<RoleTO> {
    protected final RoleDataBinder binder;
    protected final RoleDAO roleDAO;

    public RoleLogic(RoleDataBinder binder, RoleDAO roleDAO) {
        this.binder = binder;
        this.roleDAO = roleDAO;
    }

    @PreAuthorize(value="hasRole('ROLE_READ')")
    @Transactional(readOnly=true)
    public RoleTO read(String key) {
        Role role = (Role)this.roleDAO.findById(key).orElseThrow(() -> new NotFoundException("Role " + key));
        return this.binder.getRoleTO(role);
    }

    @PreAuthorize(value="hasRole('ROLE_LIST')")
    @Transactional(readOnly=true)
    public List<RoleTO> list() {
        return this.roleDAO.findAll().stream().map(arg_0 -> ((RoleDataBinder)this.binder).getRoleTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('ROLE_CREATE')")
    public RoleTO create(RoleTO roleTO) {
        return this.binder.getRoleTO(this.binder.create(roleTO));
    }

    @PreAuthorize(value="hasRole('ROLE_UPDATE')")
    public RoleTO update(RoleTO roleTO) {
        Role role = (Role)this.roleDAO.findById(roleTO.getKey()).orElseThrow(() -> new NotFoundException("Role " + roleTO.getKey()));
        return this.binder.getRoleTO(this.binder.update(role, roleTO));
    }

    @PreAuthorize(value="hasRole('ROLE_DELETE')")
    public RoleTO delete(String key) {
        Role role = (Role)this.roleDAO.findById(key).orElseThrow(() -> new NotFoundException("Role " + key));
        RoleTO deleted = this.binder.getRoleTO(role);
        this.roleDAO.delete((Entity)role);
        return deleted;
    }

    @PreAuthorize(value="isAuthenticated()")
    public String getAnyLayout(String key) {
        Role role = (Role)this.roleDAO.findById(key).orElseThrow(() -> new NotFoundException("Role " + key));
        String consoleLayout = role.getAnyLayout();
        if (StringUtils.isBlank((CharSequence)consoleLayout)) {
            throw new NotFoundException("Console layout for role " + key);
        }
        return consoleLayout;
    }

    @PreAuthorize(value="hasRole('ROLE_UPDATE')")
    public void setAnyLayout(String key, String consoleLayout) {
        Role role = (Role)this.roleDAO.findById(key).orElseThrow(() -> new NotFoundException("Role " + key));
        role.setAnyLayout(consoleLayout);
        this.roleDAO.save((Entity)role);
    }

    @Override
    protected RoleTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof RoleTO)) continue;
                RoleTO roleTO = (RoleTO)object;
                key = roleTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getRoleTO((Role)this.roleDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

