/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.deployer;

import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;

public class ParsedDeployment {
    protected DeploymentEntity deploymentEntity;
    protected List<ProcessDefinitionEntity> processDefinitions;
    protected Map<ProcessDefinitionEntity, BpmnParse> mapProcessDefinitionsToParses;
    protected Map<ProcessDefinitionEntity, EngineResource> mapProcessDefinitionsToResources;

    public ParsedDeployment(DeploymentEntity entity, List<ProcessDefinitionEntity> processDefinitions, Map<ProcessDefinitionEntity, BpmnParse> mapProcessDefinitionsToParses, Map<ProcessDefinitionEntity, EngineResource> mapProcessDefinitionsToResources) {
        this.deploymentEntity = entity;
        this.processDefinitions = processDefinitions;
        this.mapProcessDefinitionsToParses = mapProcessDefinitionsToParses;
        this.mapProcessDefinitionsToResources = mapProcessDefinitionsToResources;
    }

    public DeploymentEntity getDeployment() {
        return this.deploymentEntity;
    }

    public List<ProcessDefinitionEntity> getAllProcessDefinitions() {
        return this.processDefinitions;
    }

    public EngineResource getResourceForProcessDefinition(ProcessDefinitionEntity processDefinition) {
        return this.mapProcessDefinitionsToResources.get(processDefinition);
    }

    public BpmnParse getBpmnParseForProcessDefinition(ProcessDefinitionEntity processDefinition) {
        return this.mapProcessDefinitionsToParses.get(processDefinition);
    }

    public BpmnModel getBpmnModelForProcessDefinition(ProcessDefinitionEntity processDefinition) {
        BpmnParse parse = this.getBpmnParseForProcessDefinition(processDefinition);
        return parse == null ? null : parse.getBpmnModel();
    }

    public Process getProcessModelForProcessDefinition(ProcessDefinitionEntity processDefinition) {
        BpmnModel model = this.getBpmnModelForProcessDefinition(processDefinition);
        return model == null ? null : model.getProcessById(processDefinition.getKey());
    }
}

