/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.form.radio;

import de.agilecoders.wicket.core.markup.html.bootstrap.form.radio.IRadioChoiceRenderer;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;

public class BootstrapRadioGroup<T extends Serializable>
extends GenericPanel<T> {
    private static final long serialVersionUID = 1L;
    private final List<IModel<T>> options;
    private IRadioChoiceRenderer<T> choiceRenderer;
    private RadioGroup<T> radioGroup;
    private ISelectionChangeHandler<T> changeHandler;

    public BootstrapRadioGroup(String id, List<T> options) {
        this(id, null, options, null);
    }

    public BootstrapRadioGroup(String id, List<T> options, IRadioChoiceRenderer<T> choiceRenderer) {
        this(id, null, options, choiceRenderer);
    }

    public BootstrapRadioGroup(String id, IModel<T> model, List<T> options) {
        this(id, model, options, null);
    }

    public BootstrapRadioGroup(String id, IModel<T> model, List<T> options, IRadioChoiceRenderer<T> choiceRenderer) {
        super(id, model);
        Args.notEmpty(options, (String)"options");
        this.choiceRenderer = choiceRenderer;
        this.options = new ArrayList<IModel<T>>();
        for (Serializable t : options) {
            this.options.add(choiceRenderer != null ? choiceRenderer.modelOf(t) : Model.of((Serializable)t));
        }
    }

    protected void detachModel() {
        super.detachModel();
        for (IModel<T> model : this.options) {
            model.detach();
        }
        if (this.choiceRenderer != null) {
            this.choiceRenderer.detach();
        }
    }

    protected void onInitialize() {
        super.onInitialize();
        this.radioGroup = this.newRadioGroup("radioGroup", this.getModel());
        this.radioGroup.setRenderBodyOnly(false);
        this.radioGroup.setOutputMarkupId(true);
        this.add(new Component[]{this.radioGroup});
        if (this.changeHandler != null) {
            this.radioGroup.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    BootstrapRadioGroup.this.changeHandler.onSelectionChanged(target, (Serializable)BootstrapRadioGroup.this.radioGroup.getModel().getObject());
                }

                protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                    super.updateAjaxAttributes(attributes);
                    attributes.setEventPropagation(AjaxRequestAttributes.EventPropagation.STOP);
                }
            }});
        }
        RepeatingView radios = new RepeatingView("radios");
        this.radioGroup.add(new Component[]{radios});
        for (IModel<T> model : this.options) {
            WebMarkupContainer wm = new WebMarkupContainer(radios.newChildId());
            Radio<T> radio = this.newRadio("radio", model, this.radioGroup);
            wm.add(new Component[]{radio});
            Label label = new Label("label", this.choiceRenderer.labelOf((Serializable)model.getObject()));
            label.add(new Behavior[]{new AttributeAppender("for", (Serializable)((Object)radio.getMarkupId()))});
            wm.add(new Component[]{label});
            radios.add(new Component[]{wm.setRenderBodyOnly(true)});
        }
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("$('#" + Strings2.getMarkupId(this.radioGroup) + " .btn').button()")));
    }

    protected RadioGroup<T> newRadioGroup(String id, IModel<T> model) {
        return new RadioGroup(id, model);
    }

    protected Radio<T> newRadio(String id, IModel<T> model, RadioGroup<T> radioGroup) {
        return new Radio(id, model, radioGroup);
    }

    public void setChoiceRenderer(IRadioChoiceRenderer<T> choiceRenderer) {
        this.choiceRenderer = choiceRenderer;
    }

    public void setChangeHandler(ISelectionChangeHandler<T> handler) {
        this.changeHandler = handler;
    }

    public static interface ISelectionChangeHandler<T>
    extends Serializable {
        public void onSelectionChanged(AjaxRequestTarget var1, T var2);
    }
}

