/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.data.JEXLItemTransformer;
import org.apache.syncope.core.provisioning.api.jexl.JexlContextBuilder;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.springframework.beans.factory.annotation.Autowired;

public class JEXLItemTransformerImpl
implements JEXLItemTransformer {
    @Autowired
    private JexlTools jexlTools;
    @Autowired
    private DerAttrHandler derAttrHandler;
    private String propagationJEXL;
    private String pullJEXL;

    public void setPropagationJEXL(String propagationJEXL) {
        this.propagationJEXL = propagationJEXL;
    }

    public void setPullJEXL(String pullJEXL) {
        this.pullJEXL = pullJEXL;
    }

    protected AttrSchemaType beforePropagation(Attributable attributable, AttrSchemaType schemaType, PlainAttrValue value) {
        JexlContextBuilder builder = new JexlContextBuilder();
        if (attributable != null) {
            builder.fields((Object)attributable).plainAttrs((Collection)attributable.getPlainAttrs()).derAttrs(attributable, this.derAttrHandler);
        }
        JexlContext jexlContext = builder.build();
        jexlContext.set("value", switch (schemaType) {
            case AttrSchemaType.Binary, AttrSchemaType.Encrypted -> value.getBinaryValue();
            case AttrSchemaType.Boolean -> (Object)value.getBooleanValue();
            case AttrSchemaType.Date -> (Object)value.getDateValue();
            case AttrSchemaType.Double -> (Object)value.getDoubleValue();
            case AttrSchemaType.Long -> (Object)value.getLongValue();
            default -> (Object)value.getStringValue();
        });
        Object tValue = this.jexlTools.evaluateExpression(this.propagationJEXL, jexlContext);
        value.setBinaryValue(null);
        value.setBooleanValue(null);
        value.setDateValue(null);
        value.setDoubleValue(null);
        value.setLongValue(null);
        value.setStringValue(null);
        if (tValue instanceof byte[]) {
            byte[] bs = (byte[])tValue;
            value.setBinaryValue(bs);
            return AttrSchemaType.Binary;
        }
        if (tValue instanceof Boolean) {
            Boolean aBoolean = (Boolean)tValue;
            value.setBooleanValue(aBoolean);
            return AttrSchemaType.Boolean;
        }
        if (tValue instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)tValue;
            value.setDateValue(offsetDateTime);
            return AttrSchemaType.Date;
        }
        if (tValue instanceof Double) {
            Double aDouble = (Double)tValue;
            value.setDoubleValue(aDouble);
            return AttrSchemaType.Double;
        }
        if (tValue instanceof Long) {
            Long aLong = (Long)tValue;
            value.setLongValue(aLong);
            return AttrSchemaType.Long;
        }
        if (tValue != null) {
            value.setStringValue(tValue.toString());
        }
        return AttrSchemaType.String;
    }

    public MappingManager.IntValues beforePropagation(Item item, Attributable attributable, AttrSchemaType schemaType, List<PlainAttrValue> values) {
        if (StringUtils.isBlank((CharSequence)this.propagationJEXL)) {
            return super.beforePropagation(item, attributable, schemaType, values);
        }
        MutableObject tType = new MutableObject();
        if (values.isEmpty()) {
            PlainAttrValue value = new PlainAttrValue();
            tType.setValue((Object)this.beforePropagation(attributable, schemaType, value));
            values.add(value);
        } else {
            values.forEach(arg_0 -> this.lambda$beforePropagation$0((Mutable)tType, attributable, schemaType, arg_0));
        }
        return new MappingManager.IntValues((AttrSchemaType)tType.get(), values);
    }

    public List<Object> beforePull(Item item, EntityTO entityTO, List<Object> values) {
        if (StringUtils.isNotBlank((CharSequence)this.pullJEXL) && values != null) {
            ArrayList<Object> newValues = new ArrayList<Object>(values.size());
            values.forEach(value -> {
                JexlContextBuilder builder = new JexlContextBuilder().with("value", value).fields((Object)entityTO);
                if (entityTO instanceof AnyTO) {
                    AnyTO anyTO = (AnyTO)entityTO;
                    builder.attrs((Collection)anyTO.getPlainAttrs());
                    builder.attrs((Collection)anyTO.getDerAttrs());
                }
                JexlContext jexlContext = builder.build();
                newValues.add(this.jexlTools.evaluateExpression(this.pullJEXL, jexlContext));
            });
            return newValues;
        }
        return super.beforePull(item, entityTO, values);
    }

    private /* synthetic */ void lambda$beforePropagation$0(Mutable tType, Attributable attributable, AttrSchemaType schemaType, PlainAttrValue value) {
        tType.setValue((Object)this.beforePropagation(attributable, schemaType, value));
    }
}

