/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.ResolvableType;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideProcessor;
import org.springframework.test.context.bean.override.mockito.AbstractMockitoBeanOverrideHandler;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.context.bean.override.mockito.MockitoBeanOverrideHandler;
import org.springframework.test.context.bean.override.mockito.MockitoSpyBean;
import org.springframework.test.context.bean.override.mockito.MockitoSpyBeanOverrideHandler;
import org.springframework.util.Assert;

class MockitoBeanOverrideProcessor
implements BeanOverrideProcessor {
    MockitoBeanOverrideProcessor() {
    }

    @Override
    public AbstractMockitoBeanOverrideHandler createHandler(Annotation overrideAnnotation, Class<?> testClass, Field field) {
        if (overrideAnnotation instanceof MockitoBean) {
            MockitoBean mockitoBean = (MockitoBean)overrideAnnotation;
            Assert.state((mockitoBean.types().length == 0 ? 1 : 0) != 0, (String)"The @MockitoBean 'types' attribute must be omitted when declared on a field");
            return new MockitoBeanOverrideHandler(field, ResolvableType.forField((Field)field, testClass), mockitoBean);
        }
        if (overrideAnnotation instanceof MockitoSpyBean) {
            MockitoSpyBean mockitoSpyBean = (MockitoSpyBean)overrideAnnotation;
            Assert.state((mockitoSpyBean.types().length == 0 ? 1 : 0) != 0, (String)"The @MockitoSpyBean 'types' attribute must be omitted when declared on a field");
            return new MockitoSpyBeanOverrideHandler(field, ResolvableType.forField((Field)field, testClass), mockitoSpyBean);
        }
        throw new IllegalStateException("Invalid annotation passed to MockitoBeanOverrideProcessor: expected either @MockitoBean or @MockitoSpyBean on field %s.%s".formatted(field.getDeclaringClass().getName(), field.getName()));
    }

    @Override
    public List<BeanOverrideHandler> createHandlers(Annotation overrideAnnotation, Class<?> testClass) {
        if (overrideAnnotation instanceof MockitoBean) {
            MockitoBean mockitoBean = (MockitoBean)overrideAnnotation;
            Class<?>[] types = mockitoBean.types();
            Assert.state((types.length > 0 ? 1 : 0) != 0, (String)"The @MockitoBean 'types' attribute must not be empty when declared on a class");
            Assert.state((mockitoBean.name().isEmpty() || types.length == 1 ? 1 : 0) != 0, (String)"The @MockitoBean 'name' attribute cannot be used when mocking multiple types");
            ArrayList<BeanOverrideHandler> handlers = new ArrayList<BeanOverrideHandler>();
            for (Class<?> type : types) {
                handlers.add(new MockitoBeanOverrideHandler(ResolvableType.forClass(type), mockitoBean));
            }
            return handlers;
        }
        if (overrideAnnotation instanceof MockitoSpyBean) {
            MockitoSpyBean mockitoSpyBean = (MockitoSpyBean)overrideAnnotation;
            Class<?>[] types = mockitoSpyBean.types();
            Assert.state((types.length > 0 ? 1 : 0) != 0, (String)"The @MockitoSpyBean 'types' attribute must not be empty when declared on a class");
            Assert.state((mockitoSpyBean.name().isEmpty() || types.length == 1 ? 1 : 0) != 0, (String)"The @MockitoSpyBean 'name' attribute cannot be used when mocking multiple types");
            ArrayList<BeanOverrideHandler> handlers = new ArrayList<BeanOverrideHandler>();
            for (Class<?> type : types) {
                handlers.add(new MockitoSpyBeanOverrideHandler(ResolvableType.forClass(type), mockitoSpyBean));
            }
            return handlers;
        }
        throw new IllegalStateException("Invalid annotation passed to MockitoBeanOverrideProcessor: expected either @MockitoBean or @MockitoSpyBean on test class %s".formatted(testClass.getName()));
    }
}

