/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.resultset.closeable;

import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import java.io.Closeable;
import java.util.Iterator;

public class CloseableResultSet<O>
extends ResultSet<O>
implements Closeable {
    final ResultSet<O> wrapped;
    final Query<O> query;
    final QueryOptions queryOptions;
    boolean closed = false;

    public CloseableResultSet(ResultSet<O> wrapped, Query<O> query, QueryOptions queryOptions) {
        this.wrapped = wrapped;
        this.query = query;
        this.queryOptions = queryOptions;
    }

    @Override
    public Iterator<O> iterator() {
        this.ensureNotClosed();
        return this.wrapped.iterator();
    }

    @Override
    public boolean contains(O object) {
        this.ensureNotClosed();
        return this.wrapped.contains(object);
    }

    @Override
    public boolean matches(O object) {
        this.ensureNotClosed();
        return this.query.matches(object, this.queryOptions);
    }

    @Override
    public int size() {
        this.ensureNotClosed();
        return this.wrapped.size();
    }

    @Override
    public int getRetrievalCost() {
        this.ensureNotClosed();
        return this.wrapped.getRetrievalCost();
    }

    @Override
    public int getMergeCost() {
        this.ensureNotClosed();
        return this.wrapped.getMergeCost();
    }

    @Override
    public O uniqueResult() {
        this.ensureNotClosed();
        return this.wrapped.uniqueResult();
    }

    @Override
    public boolean isEmpty() {
        this.ensureNotClosed();
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        this.ensureNotClosed();
        return this.wrapped.isNotEmpty();
    }

    void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("ResultSet is closed");
        }
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.closed = true;
    }

    @Override
    public Query<O> getQuery() {
        return this.query;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }
}

